/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Deadline;
import org.slf4j.Logger;

public class FutureUtils {
    public static <T> T waitWithLogging(Logger log, String prefix, String action, CompletableFuture<T> future, Deadline deadline, Time time) throws Throwable {
        log.info("{}Waiting for {}", (Object)prefix, (Object)action);
        try {
            Object result = time.waitForFuture(future, deadline.nanoseconds());
            log.info("{}Finished waiting for {}", (Object)prefix, (Object)action);
            return (T)result;
        }
        catch (TimeoutException t) {
            log.error("{}Timed out while waiting for {}", new Object[]{prefix, action, t});
            TimeoutException timeout = new TimeoutException("Timed out while waiting for " + action);
            timeout.setStackTrace(t.getStackTrace());
            throw timeout;
        }
        catch (Throwable t) {
            if (t instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)t;
                t = executionException.getCause();
            }
            log.error("{}Received a fatal error while waiting for {}", new Object[]{prefix, action, t});
            throw new RuntimeException("Received a fatal error while waiting for " + action, t);
        }
    }

    public static <T> void chainFuture(CompletableFuture<? extends T> sourceFuture, CompletableFuture<T> destinationFuture) {
        sourceFuture.whenComplete((val, throwable) -> {
            if (throwable != null) {
                destinationFuture.completeExceptionally((Throwable)throwable);
            } else {
                destinationFuture.complete(val);
            }
        });
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    public static <T> CompletableFuture<T> combineFutures(List<CompletableFuture<T>> futures, Supplier<T> init, BiConsumer<T, T> add) {
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return allFutures.thenApply(v -> {
            Object res = init.get();
            futures.forEach(future -> add.accept(res, future.join()));
            return res;
        });
    }
}

