/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.rest.metrics.RestMetricsContext;
import java.util.Map;
import org.apache.kafka.common.utils.AppInfoParser;

public final class KafkaRestMetricsContext {
    private final RestMetricsContext metricsContext;
    public static final String RESOURCE_LABEL_PREFIX = "resource.";
    public static final String RESOURCE_LABEL_TYPE = "resource.type";
    public static final String RESOURCE_LABEL_VERSION = "resource.version";
    public static final String RESOURCE_LABEL_COMMIT_ID = "resource.commit.id";
    public static final String RESOURCE_LABEL_CLUSTER_ID = "resource.cluster.id";
    public static final String KAFKA_REST_RESOURCE_TYPE = "kafka_rest";
    public static final String KAFKA_REST_RESOURCE_CLUSTER_ID_DEFAULT = "cluster_id_unavailable";

    public KafkaRestMetricsContext(String namespace, Map<String, Object> config) {
        this.metricsContext = new RestMetricsContext(namespace, config);
        this.setResourceLabel(RESOURCE_LABEL_TYPE, KAFKA_REST_RESOURCE_TYPE);
        this.setResourceLabel(RESOURCE_LABEL_CLUSTER_ID, (String)config.getOrDefault(RESOURCE_LABEL_CLUSTER_ID, KAFKA_REST_RESOURCE_CLUSTER_ID_DEFAULT));
        this.setResourceLabel(RESOURCE_LABEL_VERSION, AppInfoParser.getVersion());
        this.setResourceLabel(RESOURCE_LABEL_COMMIT_ID, AppInfoParser.getCommitId());
    }

    private void setResourceLabel(String resource, String value) {
        if (this.metricsContext.getLabel(resource) == null) {
            this.metricsContext.setLabel(resource, value);
        }
    }

    public RestMetricsContext metricsContext() {
        return this.metricsContext;
    }
}

