/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.response.UrlFactoryImpl;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriInfo;
import org.apache.kafka.common.config.ConfigException;

public class UriUtils {
    public static String absoluteUri(KafkaRestConfig config, UriInfo uriInfo, String ... components) {
        List<URI> listeners;
        List<URI> advertisedListeners;
        try {
            advertisedListeners = config.getList("advertised.listeners").stream().map(URI::create).collect(Collectors.toList());
            listeners = config.getList("listeners").stream().map(URI::create).collect(Collectors.toList());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(e.getMessage());
        }
        return new UrlFactoryImpl(config.getString("host.name"), config.getInt("port"), advertisedListeners, listeners, uriInfo).create(components);
    }
}

