/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;

abstract class AbstractConsumerLagManager {
    private final Admin kafkaAdminClient;
    private static final IsolationLevel ISOLATION_LEVEL = IsolationLevel.READ_COMMITTED;

    AbstractConsumerLagManager(Admin kafkaAdminClient) {
        this.kafkaAdminClient = Objects.requireNonNull(kafkaAdminClient);
    }

    final CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> getCurrentOffsets(String consumerGroupId) {
        return KafkaFutures.toCompletableFuture(this.kafkaAdminClient.listConsumerGroupOffsets(consumerGroupId, new ListConsumerGroupOffsetsOptions()).partitionsToOffsetAndMetadata());
    }

    final CompletableFuture<Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>> getLatestOffsets(Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        Map latestOffsetSpecs = currentOffsets.keySet().stream().collect(Collectors.toMap(Function.identity(), topicPartition -> OffsetSpec.latest()));
        return KafkaFutures.toCompletableFuture(this.kafkaAdminClient.listOffsets(latestOffsetSpecs, new ListOffsetsOptions(ISOLATION_LEVEL)).all());
    }

    static final Optional<Long> getCurrentOffset(Map<TopicPartition, OffsetAndMetadata> currentOffsets, TopicPartition topicPartition) {
        OffsetAndMetadata offsetAndMetadata = currentOffsets.get(topicPartition);
        if (offsetAndMetadata == null) {
            return Optional.empty();
        }
        return Optional.of(offsetAndMetadata.offset());
    }

    static final Optional<Long> getLatestOffset(Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> latestOffsets, TopicPartition topicPartition) {
        ListOffsetsResult.ListOffsetsResultInfo offsetInfo = latestOffsets.get(topicPartition);
        if (offsetInfo == null) {
            return Optional.empty();
        }
        return Optional.of(offsetInfo.offset());
    }

    static final <T extends Map<?, ?>> T checkOffsetsExist(T offsets, String message, Object ... args) {
        if (offsets.isEmpty()) {
            throw new NotFoundException(String.format(message, args));
        }
        return offsets;
    }
}

