/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.AbstractConfigManager;
import io.confluent.kafkarest.controllers.BrokerConfigManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.entities.AlterConfigCommand;
import io.confluent.kafkarest.entities.BrokerConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.config.ConfigResource;

final class BrokerConfigManagerImpl
extends AbstractConfigManager<BrokerConfig, BrokerConfig.Builder>
implements BrokerConfigManager {
    @Inject
    BrokerConfigManagerImpl(Admin adminClient, ClusterManager clusterManager) {
        super(adminClient, clusterManager);
    }

    @Override
    public CompletableFuture<List<BrokerConfig>> listBrokerConfigs(String clusterId, int brokerId) {
        return this.listConfigs(clusterId, new ConfigResource(ConfigResource.Type.BROKER, String.valueOf(brokerId)), ((BrokerConfig.Builder)BrokerConfig.builder().setClusterId(clusterId)).setBrokerId(brokerId));
    }

    @Override
    public CompletableFuture<Map<Integer, List<BrokerConfig>>> listAllBrokerConfigs(String clusterId, List<Integer> brokerIds) {
        List<ConfigResource> brokerResources = brokerIds.stream().map(brokerId -> new ConfigResource(ConfigResource.Type.BROKER, String.valueOf(brokerId))).collect(Collectors.toList());
        return this.listConfigs(clusterId, brokerResources, ((BrokerConfig.Builder)BrokerConfig.builder().setClusterId(clusterId)).setBrokerId(-1)).thenApply(configs -> configs.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt(((ConfigResource)e.getKey()).name()), e -> ((List)e.getValue()).stream().map(config -> BrokerConfig.create(config.getClusterId(), Integer.parseInt(((ConfigResource)e.getKey()).name()), config.getName(), config.getValue(), config.isDefault(), config.isReadOnly(), config.isSensitive(), config.getSource(), config.getSynonyms())).collect(Collectors.toList()))));
    }

    @Override
    public CompletableFuture<Optional<BrokerConfig>> getBrokerConfig(String clusterId, int brokerId, String name) {
        return this.getConfig(clusterId, new ConfigResource(ConfigResource.Type.BROKER, String.valueOf(brokerId)), ((BrokerConfig.Builder)BrokerConfig.builder().setClusterId(clusterId)).setBrokerId(brokerId), name);
    }

    @Override
    public CompletableFuture<Void> updateBrokerConfig(String clusterId, int brokerId, String name, String newValue) {
        return this.safeUpdateConfig(clusterId, new ConfigResource(ConfigResource.Type.BROKER, String.valueOf(brokerId)), ((BrokerConfig.Builder)BrokerConfig.builder().setClusterId(clusterId)).setBrokerId(brokerId), name, newValue);
    }

    @Override
    public CompletableFuture<Void> resetBrokerConfig(String clusterId, int brokerId, String name) {
        return this.safeResetConfig(clusterId, new ConfigResource(ConfigResource.Type.BROKER, String.valueOf(brokerId)), ((BrokerConfig.Builder)BrokerConfig.builder().setClusterId(clusterId)).setBrokerId(brokerId), name);
    }

    @Override
    public CompletableFuture<Void> alterBrokerConfigs(String clusterId, int brokerId, List<AlterConfigCommand> commands) {
        return this.safeAlterConfigs(clusterId, new ConfigResource(ConfigResource.Type.BROKER, String.valueOf(brokerId)), ((BrokerConfig.Builder)BrokerConfig.builder().setClusterId(clusterId)).setBrokerId(brokerId), commands);
    }
}

