/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.common.CompletableFutures;
import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.PartitionManager;
import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.Topic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PartitionManagerImpl
implements PartitionManager {
    private final Admin adminClient;
    private final TopicManager topicManager;
    private static final Logger log = LoggerFactory.getLogger(PartitionManagerImpl.class);

    @Inject
    PartitionManagerImpl(Admin adminClient, TopicManager topicManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.topicManager = Objects.requireNonNull(topicManager);
    }

    @Override
    public CompletableFuture<List<Partition>> listPartitions(String clusterId, String topicName) {
        return ((CompletableFuture)((CompletableFuture)this.topicManager.getTopic(clusterId, topicName).thenApply(topic -> (Topic)Entities.checkEntityExists(topic, "Topic %s cannot be found.", topic))).thenApply(Topic::getPartitions)).thenCompose(this::withOffsets);
    }

    @Override
    public CompletableFuture<List<Partition>> listLocalPartitions(String topicName) {
        return ((CompletableFuture)((CompletableFuture)this.topicManager.getLocalTopic(topicName).thenApply(topic -> (Topic)Entities.checkEntityExists(topic, "Topic %s cannot be found.", topic))).thenApply(Topic::getPartitions)).thenCompose(this::withOffsets);
    }

    @Override
    public CompletableFuture<Optional<Partition>> getPartition(String clusterId, String topicName, int partitionId) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.topicManager.getTopic(clusterId, topicName).thenApply(topic -> (Topic)Entities.checkEntityExists(topic, "Topic %s cannot be found.", topic))).thenApply(Topic::getPartitions)).thenApply(partitions -> Entities.findEntityByKey(partitions, Partition::getPartitionId, partitionId))).thenApply(partition -> partition.map(Collections::singletonList).orElse(Collections.emptyList()))).thenCompose(this::withOffsets)).thenApply(partitions -> partitions.stream().findAny())).exceptionally(exception -> {
            if (exception.getCause() instanceof UnknownTopicOrPartitionException) {
                String exceptionMessage = String.format("This server does not host topic-partition %d for topic %s", partitionId, topicName);
                throw new UnknownTopicOrPartitionException(exceptionMessage, exception);
            }
            if (exception instanceof NotFoundException || exception.getCause() instanceof NotFoundException) {
                throw new NotFoundException(exception.getCause());
            }
            if (exception instanceof RuntimeException || exception.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new CompletionException(exception.getCause());
        });
    }

    @Override
    public CompletableFuture<Optional<Partition>> getPartitionAllowMissing(String clusterId, String topicName, int partitionId) {
        return ((CompletableFuture)this.topicManager.getTopic(clusterId, topicName).thenApply(topic -> topic.map(Topic::getPartitions).orElse(ImmutableList.of()))).thenApply(partitions -> partitions.stream().filter(partition -> partition.getPartitionId() == partitionId).findAny());
    }

    @Override
    public CompletableFuture<Optional<Partition>> getLocalPartition(String topicName, int partitionId) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.topicManager.getLocalTopic(topicName).thenApply(topic -> (Topic)Entities.checkEntityExists(topic, "Topic %s cannot be found.", topic))).thenApply(Topic::getPartitions)).thenApply(partitions -> Entities.findEntityByKey(partitions, Partition::getPartitionId, partitionId))).thenApply(partition -> partition.map(Collections::singletonList).orElse(Collections.emptyList()))).thenCompose(this::withOffsets)).thenApply(partitions -> partitions.stream().findAny());
    }

    private CompletableFuture<List<Partition>> withOffsets(List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ListOffsetsResult earliestResponse = this.listOffsets(partitions, OffsetSpec.earliest());
        ListOffsetsResult latestResponse = this.listOffsets(partitions, OffsetSpec.latest());
        ArrayList partitionsWithOffsets = new ArrayList();
        for (Partition partition : partitions) {
            CompletableFuture earliestFuture = KafkaFutures.toCompletableFuture(earliestResponse.partitionResult(PartitionManagerImpl.toTopicPartition(partition)));
            CompletableFuture latestFuture = KafkaFutures.toCompletableFuture(latestResponse.partitionResult(PartitionManagerImpl.toTopicPartition(partition)));
            CompletionStage partitionWithOffset = earliestFuture.thenCombine((CompletionStage)latestFuture, (earliest, latest) -> Partition.create(partition.getClusterId(), partition.getTopicName(), partition.getPartitionId(), partition.getReplicas(), earliest.offset(), latest.offset()));
            partitionsWithOffsets.add(partitionWithOffset);
        }
        return CompletableFutures.allAsList(partitionsWithOffsets);
    }

    private ListOffsetsResult listOffsets(List<Partition> partitions, OffsetSpec offsetSpec) {
        HashMap<TopicPartition, OffsetSpec> request = new HashMap<TopicPartition, OffsetSpec>();
        for (Partition partition : partitions) {
            request.put(PartitionManagerImpl.toTopicPartition(partition), offsetSpec);
        }
        return this.adminClient.listOffsets(request, new ListOffsetsOptions());
    }

    private static TopicPartition toTopicPartition(Partition partition) {
        return new TopicPartition(partition.getTopicName(), partition.getPartitionId());
    }
}

