/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.ReassignmentManager;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.Reassignment;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.TopicPartition;

final class ReassignmentManagerImpl
implements ReassignmentManager {
    private final Admin adminClient;
    private final ClusterManager clusterManager;

    @Inject
    ReassignmentManagerImpl(Admin adminClient, ClusterManager clusterManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.clusterManager = Objects.requireNonNull(clusterManager);
    }

    @Override
    public CompletableFuture<List<Reassignment>> listReassignments(String clusterId) {
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenCompose(cluster -> KafkaFutures.toCompletableFuture(this.adminClient.listPartitionReassignments().reassignments()))).thenApply(reassignments -> {
            if (reassignments == null) {
                return Collections.emptyList();
            }
            return reassignments.entrySet().stream().map(reassignment -> ReassignmentManagerImpl.toReassignment(clusterId, reassignment)).sorted(Comparator.comparing(Reassignment::getTopicName).thenComparing(Reassignment::getPartitionId)).collect(Collectors.toList());
        });
    }

    @Override
    public CompletableFuture<List<Reassignment>> searchReassignmentsByTopicName(String clusterId, String topicName) {
        return this.listReassignments(clusterId).thenApply(reassignments -> reassignments.stream().filter(reassignment -> reassignment.getTopicName().equals(topicName)).sorted(Comparator.comparing(Reassignment::getTopicName).thenComparing(Reassignment::getPartitionId)).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Optional<Reassignment>> getReassignment(String clusterId, String topicName, Integer partitionId) {
        return this.listReassignments(clusterId).thenApply(reassignments -> reassignments.stream().filter(reassignment -> reassignment.getTopicName().equals(topicName)).filter(reassignment -> reassignment.getPartitionId() == partitionId.intValue()).findAny());
    }

    private static Reassignment toReassignment(String clusterId, Map.Entry<TopicPartition, PartitionReassignment> reassignment) {
        return Reassignment.create(clusterId, reassignment.getKey().topic(), reassignment.getKey().partition(), reassignment.getValue().addingReplicas(), reassignment.getValue().removingReplicas());
    }
}

