/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.ConsumerGroup;
import java.util.List;

final class AutoValue_ConsumerGroup
extends ConsumerGroup {
    private final String clusterId;
    private final String consumerGroupId;
    private final boolean simple;
    private final String partitionAssignor;
    private final ConsumerGroup.State state;
    private final Broker coordinator;
    private final ImmutableList<Consumer> consumers;

    private AutoValue_ConsumerGroup(String clusterId, String consumerGroupId, boolean simple, String partitionAssignor, ConsumerGroup.State state, Broker coordinator, ImmutableList<Consumer> consumers) {
        this.clusterId = clusterId;
        this.consumerGroupId = consumerGroupId;
        this.simple = simple;
        this.partitionAssignor = partitionAssignor;
        this.state = state;
        this.coordinator = coordinator;
        this.consumers = consumers;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    @Override
    public String getPartitionAssignor() {
        return this.partitionAssignor;
    }

    @Override
    public ConsumerGroup.State getState() {
        return this.state;
    }

    @Override
    public Broker getCoordinator() {
        return this.coordinator;
    }

    @Override
    public ImmutableList<Consumer> getConsumers() {
        return this.consumers;
    }

    public String toString() {
        return "ConsumerGroup{clusterId=" + this.clusterId + ", consumerGroupId=" + this.consumerGroupId + ", simple=" + this.simple + ", partitionAssignor=" + this.partitionAssignor + ", state=" + (Object)((Object)this.state) + ", coordinator=" + this.coordinator + ", consumers=" + this.consumers + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConsumerGroup) {
            ConsumerGroup that = (ConsumerGroup)o;
            return this.clusterId.equals(that.getClusterId()) && this.consumerGroupId.equals(that.getConsumerGroupId()) && this.simple == that.isSimple() && this.partitionAssignor.equals(that.getPartitionAssignor()) && this.state.equals((Object)that.getState()) && this.coordinator.equals(that.getCoordinator()) && this.consumers.equals(that.getConsumers());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.consumerGroupId.hashCode();
        h$ *= 1000003;
        h$ ^= this.simple ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.partitionAssignor.hashCode();
        h$ *= 1000003;
        h$ ^= this.state.hashCode();
        h$ *= 1000003;
        h$ ^= this.coordinator.hashCode();
        h$ *= 1000003;
        return h$ ^= this.consumers.hashCode();
    }

    static final class Builder
    extends ConsumerGroup.Builder {
        private String clusterId;
        private String consumerGroupId;
        private Boolean simple;
        private String partitionAssignor;
        private ConsumerGroup.State state;
        private Broker coordinator;
        private ImmutableList<Consumer> consumers;

        Builder() {
        }

        @Override
        public ConsumerGroup.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setConsumerGroupId(String consumerGroupId) {
            if (consumerGroupId == null) {
                throw new NullPointerException("Null consumerGroupId");
            }
            this.consumerGroupId = consumerGroupId;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setSimple(boolean simple) {
            this.simple = simple;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setPartitionAssignor(String partitionAssignor) {
            if (partitionAssignor == null) {
                throw new NullPointerException("Null partitionAssignor");
            }
            this.partitionAssignor = partitionAssignor;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setState(ConsumerGroup.State state) {
            if (state == null) {
                throw new NullPointerException("Null state");
            }
            this.state = state;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setCoordinator(Broker coordinator) {
            if (coordinator == null) {
                throw new NullPointerException("Null coordinator");
            }
            this.coordinator = coordinator;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setConsumers(List<Consumer> consumers) {
            this.consumers = ImmutableList.copyOf(consumers);
            return this;
        }

        @Override
        public ConsumerGroup build() {
            String missing = "";
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.consumerGroupId == null) {
                missing = missing + " consumerGroupId";
            }
            if (this.simple == null) {
                missing = missing + " simple";
            }
            if (this.partitionAssignor == null) {
                missing = missing + " partitionAssignor";
            }
            if (this.state == null) {
                missing = missing + " state";
            }
            if (this.coordinator == null) {
                missing = missing + " coordinator";
            }
            if (this.consumers == null) {
                missing = missing + " consumers";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ConsumerGroup(this.clusterId, this.consumerGroupId, this.simple, this.partitionAssignor, this.state, this.coordinator, this.consumers);
        }
    }
}

