/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Acl;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.Topic;
import java.util.Set;

final class AutoValue_Topic
extends Topic {
    private final String clusterId;
    private final String name;
    private final ImmutableList<Partition> partitions;
    private final short replicationFactor;
    private final boolean internal;
    private final Set<Acl.Operation> authorizedOperations;

    private AutoValue_Topic(String clusterId, String name, ImmutableList<Partition> partitions, short replicationFactor, boolean internal, Set<Acl.Operation> authorizedOperations) {
        this.clusterId = clusterId;
        this.name = name;
        this.partitions = partitions;
        this.replicationFactor = replicationFactor;
        this.internal = internal;
        this.authorizedOperations = authorizedOperations;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableList<Partition> getPartitions() {
        return this.partitions;
    }

    @Override
    public short getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public Set<Acl.Operation> getAuthorizedOperations() {
        return this.authorizedOperations;
    }

    public String toString() {
        return "Topic{clusterId=" + this.clusterId + ", name=" + this.name + ", partitions=" + this.partitions + ", replicationFactor=" + this.replicationFactor + ", internal=" + this.internal + ", authorizedOperations=" + this.authorizedOperations + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Topic) {
            Topic that = (Topic)o;
            return this.clusterId.equals(that.getClusterId()) && this.name.equals(that.getName()) && this.partitions.equals(that.getPartitions()) && this.replicationFactor == that.getReplicationFactor() && this.internal == that.isInternal() && this.authorizedOperations.equals(that.getAuthorizedOperations());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.replicationFactor;
        h$ *= 1000003;
        h$ ^= this.internal ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.authorizedOperations.hashCode();
    }

    static final class Builder
    extends Topic.Builder {
        private String clusterId;
        private String name;
        private ImmutableList.Builder<Partition> partitionsBuilder$;
        private ImmutableList<Partition> partitions;
        private Short replicationFactor;
        private Boolean internal;
        private Set<Acl.Operation> authorizedOperations;

        Builder() {
        }

        @Override
        public Topic.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public Topic.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        ImmutableList.Builder<Partition> partitionsBuilder() {
            if (this.partitionsBuilder$ == null) {
                this.partitionsBuilder$ = ImmutableList.builder();
            }
            return this.partitionsBuilder$;
        }

        @Override
        public Topic.Builder setReplicationFactor(short replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        @Override
        public Topic.Builder setInternal(boolean internal) {
            this.internal = internal;
            return this;
        }

        @Override
        public Topic.Builder setAuthorizedOperations(Set<Acl.Operation> authorizedOperations) {
            if (authorizedOperations == null) {
                throw new NullPointerException("Null authorizedOperations");
            }
            this.authorizedOperations = authorizedOperations;
            return this;
        }

        @Override
        public Topic build() {
            if (this.partitionsBuilder$ != null) {
                this.partitions = this.partitionsBuilder$.build();
            } else if (this.partitions == null) {
                this.partitions = ImmutableList.of();
            }
            String missing = "";
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.replicationFactor == null) {
                missing = missing + " replicationFactor";
            }
            if (this.internal == null) {
                missing = missing + " internal";
            }
            if (this.authorizedOperations == null) {
                missing = missing + " authorizedOperations";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Topic(this.clusterId, this.name, this.partitions, this.replicationFactor, this.internal, this.authorizedOperations);
        }
    }
}

