/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.AutoValue_Broker;
import javax.annotation.Nullable;
import org.apache.kafka.common.Node;

@AutoValue
public abstract class Broker {
    Broker() {
    }

    public abstract String getClusterId();

    public abstract int getBrokerId();

    @Nullable
    public abstract String getHost();

    @Nullable
    public abstract Integer getPort();

    @Nullable
    public abstract String getRack();

    public static Broker create(String clusterId, int brokerId, @Nullable String host, @Nullable Integer port, @Nullable String rack) {
        return new AutoValue_Broker(clusterId, brokerId, host, port, rack);
    }

    public static Broker fromNode(String clusterId, Node node) {
        return Broker.create(clusterId, node.id(), !node.host().equals("") ? node.host() : null, node.port() != -1 ? Integer.valueOf(node.port()) : null, node.rack());
    }

    public Node toNode() {
        return new Node(this.getBrokerId(), this.getHost() != null ? this.getHost() : "", this.getPort() != null ? this.getPort() : -1, this.getRack());
    }
}

