/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.AutoValue_Consumer;
import io.confluent.kafkarest.entities.Partition;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.MemberDescription;

@AutoValue
public abstract class Consumer {
    Consumer() {
    }

    public abstract String getClusterId();

    public abstract String getConsumerGroupId();

    public abstract String getConsumerId();

    public abstract Optional<String> getInstanceId();

    public abstract String getClientId();

    public abstract String getHost();

    public abstract ImmutableList<Partition> getAssignedPartitions();

    public static Builder builder() {
        return new AutoValue_Consumer.Builder();
    }

    public static Consumer fromMemberDescription(String clusterId, String consumerGroupId, MemberDescription description) {
        return Consumer.builder().setClusterId(clusterId).setConsumerGroupId(consumerGroupId).setConsumerId(description.consumerId()).setInstanceId(description.groupInstanceId().orElse(null)).setClientId(description.clientId()).setHost(description.host()).setAssignedPartitions(description.assignment().topicPartitions().stream().map(partition -> Partition.create(clusterId, partition.topic(), partition.partition(), Collections.emptyList())).collect(Collectors.toList())).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setConsumerGroupId(String var1);

        public abstract Builder setConsumerId(String var1);

        public abstract Builder setInstanceId(@Nullable String var1);

        public abstract Builder setClientId(String var1);

        public abstract Builder setHost(String var1);

        public abstract Builder setAssignedPartitions(List<Partition> var1);

        public abstract Consumer build();
    }
}

