/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.entities.AutoValue_ConsumerGroup;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.Partition;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.common.ConsumerGroupState;

@AutoValue
public abstract class ConsumerGroup {
    ConsumerGroup() {
    }

    public abstract String getClusterId();

    public abstract String getConsumerGroupId();

    public abstract boolean isSimple();

    public abstract String getPartitionAssignor();

    public abstract State getState();

    public abstract Broker getCoordinator();

    public abstract ImmutableList<Consumer> getConsumers();

    public final ImmutableMap<Partition, Consumer> getPartitionAssignment() {
        ImmutableMap.Builder partitionAssignment = ImmutableMap.builder();
        for (Consumer consumer : this.getConsumers()) {
            for (Partition partition : consumer.getAssignedPartitions()) {
                partitionAssignment.put((Object)partition, (Object)consumer);
            }
        }
        return partitionAssignment.build();
    }

    public static Builder builder() {
        return new AutoValue_ConsumerGroup.Builder();
    }

    public static ConsumerGroup fromConsumerGroupDescription(String clusterId, ConsumerGroupDescription description) {
        return ConsumerGroup.builder().setClusterId(clusterId).setConsumerGroupId(description.groupId()).setSimple(description.isSimpleConsumerGroup()).setPartitionAssignor(description.partitionAssignor()).setState(State.fromConsumerGroupState(description.state())).setCoordinator(Broker.fromNode(clusterId, description.coordinator())).setConsumers(description.members().stream().map(consumer -> Consumer.fromMemberDescription(clusterId, description.groupId(), consumer)).collect(Collectors.toList())).build();
    }

    public static enum State {
        UNKNOWN,
        PREPARING_REBALANCE,
        COMPLETING_REBALANCE,
        STABLE,
        DEAD,
        EMPTY;


        public static State fromConsumerGroupState(ConsumerGroupState state) {
            try {
                return State.valueOf(state.name());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public ConsumerGroupState toConsumerGroupState() {
            try {
                return ConsumerGroupState.valueOf((String)this.name());
            }
            catch (IllegalArgumentException e) {
                return ConsumerGroupState.UNKNOWN;
            }
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setConsumerGroupId(String var1);

        public abstract Builder setSimple(boolean var1);

        public abstract Builder setPartitionAssignor(String var1);

        public abstract Builder setState(State var1);

        public abstract Builder setCoordinator(Broker var1);

        public abstract Builder setConsumers(List<Consumer> var1);

        public abstract ConsumerGroup build();
    }
}

