/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.ProduceRecord;
import io.confluent.kafkarest.entities.ProduceRequest;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;

public final class JsonPartitionProduceRequest {
    @NotEmpty
    @Nullable
    private final List<JsonPartitionProduceRecord> records;

    @JsonCreator
    private JsonPartitionProduceRequest(@JsonProperty(value="records") @Nullable List<JsonPartitionProduceRecord> records, @JsonProperty(value="key_schema") @Nullable String keySchema, @JsonProperty(value="key_schema_id") @Nullable Integer keySchemaId, @JsonProperty(value="value_schema") @Nullable String valueSchema, @JsonProperty(value="value_schema_id") @Nullable Integer valueSchemaId) {
        this.records = records;
    }

    @JsonProperty(value="records")
    @Nullable
    public List<JsonPartitionProduceRecord> getRecords() {
        return this.records;
    }

    public static JsonPartitionProduceRequest create(List<JsonPartitionProduceRecord> records) {
        if (records.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new JsonPartitionProduceRequest(records, null, null, null, null);
    }

    public ProduceRequest<Object, Object> toProduceRequest() {
        if (this.records == null || this.records.isEmpty()) {
            throw new IllegalStateException();
        }
        return ProduceRequest.create(this.records.stream().map(record -> ProduceRecord.create(((JsonPartitionProduceRecord)record).key, ((JsonPartitionProduceRecord)record).value, null)).collect(Collectors.toList()), null, null, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPartitionProduceRequest that = (JsonPartitionProduceRequest)o;
        return Objects.equals(this.records, that.records);
    }

    public int hashCode() {
        return Objects.hash(this.records);
    }

    public String toString() {
        return new StringJoiner(", ", JsonPartitionProduceRequest.class.getSimpleName() + "[", "]").add("records=" + this.records).toString();
    }

    public static final class JsonPartitionProduceRecord {
        @Nullable
        private final Object key;
        @Nullable
        private final Object value;

        @JsonCreator
        public JsonPartitionProduceRecord(@JsonProperty(value="key") @Nullable Object key, @JsonProperty(value="value") @Nullable Object value) {
            this.key = key;
            this.value = value;
        }

        @JsonProperty(value="key")
        @Nullable
        public Object getKey() {
            return this.key;
        }

        @JsonProperty(value="value")
        @Nullable
        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonPartitionProduceRecord that = (JsonPartitionProduceRecord)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return new StringJoiner(", ", JsonPartitionProduceRecord.class.getSimpleName() + "[", "]").add("key=" + this.key).add("value=" + this.value).toString();
        }
    }
}

