/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.ClusterData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_ClusterData
extends ClusterData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final Optional<Resource.Relationship> controller;
    private final Resource.Relationship acls;
    private final Resource.Relationship brokers;
    private final Resource.Relationship brokerConfigs;
    private final Resource.Relationship consumerGroups;
    private final Resource.Relationship topics;
    private final Resource.Relationship partitionReassignments;

    private AutoValue_ClusterData(String kind, Resource.Metadata metadata, String clusterId, Optional<Resource.Relationship> controller, Resource.Relationship acls, Resource.Relationship brokers, Resource.Relationship brokerConfigs, Resource.Relationship consumerGroups, Resource.Relationship topics, Resource.Relationship partitionReassignments) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.controller = controller;
        this.acls = acls;
        this.brokers = brokers;
        this.brokerConfigs = brokerConfigs;
        this.consumerGroups = consumerGroups;
        this.topics = topics;
        this.partitionReassignments = partitionReassignments;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="controller")
    public Optional<Resource.Relationship> getController() {
        return this.controller;
    }

    @Override
    @JsonProperty(value="acls")
    public Resource.Relationship getAcls() {
        return this.acls;
    }

    @Override
    @JsonProperty(value="brokers")
    public Resource.Relationship getBrokers() {
        return this.brokers;
    }

    @Override
    @JsonProperty(value="broker_configs")
    public Resource.Relationship getBrokerConfigs() {
        return this.brokerConfigs;
    }

    @Override
    @JsonProperty(value="consumer_groups")
    public Resource.Relationship getConsumerGroups() {
        return this.consumerGroups;
    }

    @Override
    @JsonProperty(value="topics")
    public Resource.Relationship getTopics() {
        return this.topics;
    }

    @Override
    @JsonProperty(value="partition_reassignments")
    public Resource.Relationship getPartitionReassignments() {
        return this.partitionReassignments;
    }

    public String toString() {
        return "ClusterData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", controller=" + this.controller + ", acls=" + this.acls + ", brokers=" + this.brokers + ", brokerConfigs=" + this.brokerConfigs + ", consumerGroups=" + this.consumerGroups + ", topics=" + this.topics + ", partitionReassignments=" + this.partitionReassignments + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClusterData) {
            ClusterData that = (ClusterData)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.controller.equals(that.getController()) && this.acls.equals(that.getAcls()) && this.brokers.equals(that.getBrokers()) && this.brokerConfigs.equals(that.getBrokerConfigs()) && this.consumerGroups.equals(that.getConsumerGroups()) && this.topics.equals(that.getTopics()) && this.partitionReassignments.equals(that.getPartitionReassignments());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.controller.hashCode();
        h$ *= 1000003;
        h$ ^= this.acls.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokers.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerConfigs.hashCode();
        h$ *= 1000003;
        h$ ^= this.consumerGroups.hashCode();
        h$ *= 1000003;
        h$ ^= this.topics.hashCode();
        h$ *= 1000003;
        return h$ ^= this.partitionReassignments.hashCode();
    }

    static final class Builder
    extends ClusterData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private Optional<Resource.Relationship> controller = Optional.empty();
        private Resource.Relationship acls;
        private Resource.Relationship brokers;
        private Resource.Relationship brokerConfigs;
        private Resource.Relationship consumerGroups;
        private Resource.Relationship topics;
        private Resource.Relationship partitionReassignments;

        Builder() {
        }

        @Override
        public ClusterData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public ClusterData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public ClusterData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ClusterData.Builder setController(@Nullable Resource.Relationship controller) {
            this.controller = Optional.ofNullable(controller);
            return this;
        }

        @Override
        public ClusterData.Builder setAcls(Resource.Relationship acls) {
            if (acls == null) {
                throw new NullPointerException("Null acls");
            }
            this.acls = acls;
            return this;
        }

        @Override
        public ClusterData.Builder setBrokers(Resource.Relationship brokers) {
            if (brokers == null) {
                throw new NullPointerException("Null brokers");
            }
            this.brokers = brokers;
            return this;
        }

        @Override
        public ClusterData.Builder setBrokerConfigs(Resource.Relationship brokerConfigs) {
            if (brokerConfigs == null) {
                throw new NullPointerException("Null brokerConfigs");
            }
            this.brokerConfigs = brokerConfigs;
            return this;
        }

        @Override
        public ClusterData.Builder setConsumerGroups(Resource.Relationship consumerGroups) {
            if (consumerGroups == null) {
                throw new NullPointerException("Null consumerGroups");
            }
            this.consumerGroups = consumerGroups;
            return this;
        }

        @Override
        public ClusterData.Builder setTopics(Resource.Relationship topics) {
            if (topics == null) {
                throw new NullPointerException("Null topics");
            }
            this.topics = topics;
            return this;
        }

        @Override
        public ClusterData.Builder setPartitionReassignments(Resource.Relationship partitionReassignments) {
            if (partitionReassignments == null) {
                throw new NullPointerException("Null partitionReassignments");
            }
            this.partitionReassignments = partitionReassignments;
            return this;
        }

        @Override
        public ClusterData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.acls == null) {
                missing = missing + " acls";
            }
            if (this.brokers == null) {
                missing = missing + " brokers";
            }
            if (this.brokerConfigs == null) {
                missing = missing + " brokerConfigs";
            }
            if (this.consumerGroups == null) {
                missing = missing + " consumerGroups";
            }
            if (this.topics == null) {
                missing = missing + " topics";
            }
            if (this.partitionReassignments == null) {
                missing = missing + " partitionReassignments";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ClusterData(this.kind, this.metadata, this.clusterId, this.controller, this.acls, this.brokers, this.brokerConfigs, this.consumerGroups, this.topics, this.partitionReassignments);
        }
    }
}

