/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.ReassignmentData;
import io.confluent.kafkarest.entities.v3.ReassignmentDataList;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import java.util.List;

final class AutoValue_ReassignmentDataList
extends ReassignmentDataList {
    private final String kind;
    private final ResourceCollection.Metadata metadata;
    private final ImmutableList<ReassignmentData> data;

    private AutoValue_ReassignmentDataList(String kind, ResourceCollection.Metadata metadata, ImmutableList<ReassignmentData> data) {
        this.kind = kind;
        this.metadata = metadata;
        this.data = data;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ResourceCollection.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="data")
    public ImmutableList<ReassignmentData> getData() {
        return this.data;
    }

    public String toString() {
        return "ReassignmentDataList{kind=" + this.kind + ", metadata=" + this.metadata + ", data=" + this.data + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReassignmentDataList) {
            ReassignmentDataList that = (ReassignmentDataList)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.data.equals(that.getData());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        return h$ ^= this.data.hashCode();
    }

    static final class Builder
    extends ReassignmentDataList.Builder {
        private String kind;
        private ResourceCollection.Metadata metadata;
        private ImmutableList<ReassignmentData> data;

        Builder() {
        }

        @Override
        public ReassignmentDataList.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public ReassignmentDataList.Builder setMetadata(ResourceCollection.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public ReassignmentDataList.Builder setData(List<ReassignmentData> data) {
            this.data = ImmutableList.copyOf(data);
            return this;
        }

        @Override
        public ReassignmentDataList build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.data == null) {
                missing = missing + " data";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ReassignmentDataList(this.kind, this.metadata, this.data);
        }
    }
}

