/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.ReplicaData;
import io.confluent.kafkarest.entities.v3.Resource;

final class AutoValue_ReplicaData
extends ReplicaData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final String topicName;
    private final int partitionId;
    private final int brokerId;
    private final boolean leader;
    private final boolean inSync;
    private final Resource.Relationship broker;

    private AutoValue_ReplicaData(String kind, Resource.Metadata metadata, String clusterId, String topicName, int partitionId, int brokerId, boolean leader, boolean inSync, Resource.Relationship broker) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.topicName = topicName;
        this.partitionId = partitionId;
        this.brokerId = brokerId;
        this.leader = leader;
        this.inSync = inSync;
        this.broker = broker;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="topic_name")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonProperty(value="partition_id")
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="broker_id")
    public int getBrokerId() {
        return this.brokerId;
    }

    @Override
    @JsonProperty(value="is_leader")
    public boolean isLeader() {
        return this.leader;
    }

    @Override
    @JsonProperty(value="is_in_sync")
    public boolean isInSync() {
        return this.inSync;
    }

    @Override
    @JsonProperty(value="broker")
    public Resource.Relationship getBroker() {
        return this.broker;
    }

    public String toString() {
        return "ReplicaData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", topicName=" + this.topicName + ", partitionId=" + this.partitionId + ", brokerId=" + this.brokerId + ", leader=" + this.leader + ", inSync=" + this.inSync + ", broker=" + this.broker + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReplicaData) {
            ReplicaData that = (ReplicaData)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.topicName.equals(that.getTopicName()) && this.partitionId == that.getPartitionId() && this.brokerId == that.getBrokerId() && this.leader == that.isLeader() && this.inSync == that.isInSync() && this.broker.equals(that.getBroker());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionId;
        h$ *= 1000003;
        h$ ^= this.brokerId;
        h$ *= 1000003;
        h$ ^= this.leader ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.inSync ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.broker.hashCode();
    }

    static final class Builder
    extends ReplicaData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private String topicName;
        private Integer partitionId;
        private Integer brokerId;
        private Boolean leader;
        private Boolean inSync;
        private Resource.Relationship broker;

        Builder() {
        }

        @Override
        public ReplicaData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public ReplicaData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public ReplicaData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ReplicaData.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public ReplicaData.Builder setPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public ReplicaData.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public ReplicaData.Builder setLeader(boolean leader) {
            this.leader = leader;
            return this;
        }

        @Override
        public ReplicaData.Builder setInSync(boolean inSync) {
            this.inSync = inSync;
            return this;
        }

        @Override
        public ReplicaData.Builder setBroker(Resource.Relationship broker) {
            if (broker == null) {
                throw new NullPointerException("Null broker");
            }
            this.broker = broker;
            return this;
        }

        @Override
        public ReplicaData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.topicName == null) {
                missing = missing + " topicName";
            }
            if (this.partitionId == null) {
                missing = missing + " partitionId";
            }
            if (this.brokerId == null) {
                missing = missing + " brokerId";
            }
            if (this.leader == null) {
                missing = missing + " leader";
            }
            if (this.inSync == null) {
                missing = missing + " inSync";
            }
            if (this.broker == null) {
                missing = missing + " broker";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ReplicaData(this.kind, this.metadata, this.clusterId, this.topicName, this.partitionId, this.brokerId, this.leader, this.inSync, this.broker);
        }
    }
}

