/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.confluent.kafkarest.entities.Acl;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.TopicData;
import java.util.Set;

final class AutoValue_TopicData
extends TopicData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final String topicName;
    private final boolean internal;
    private final int replicationFactor;
    private final int partitionsCount;
    private final Resource.Relationship partitions;
    private final Resource.Relationship configs;
    private final Resource.Relationship partitionReassignments;
    private final ImmutableSet<Acl.Operation> authorizedOperations;

    private AutoValue_TopicData(String kind, Resource.Metadata metadata, String clusterId, String topicName, boolean internal, int replicationFactor, int partitionsCount, Resource.Relationship partitions, Resource.Relationship configs, Resource.Relationship partitionReassignments, ImmutableSet<Acl.Operation> authorizedOperations) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.topicName = topicName;
        this.internal = internal;
        this.replicationFactor = replicationFactor;
        this.partitionsCount = partitionsCount;
        this.partitions = partitions;
        this.configs = configs;
        this.partitionReassignments = partitionReassignments;
        this.authorizedOperations = authorizedOperations;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="topic_name")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonProperty(value="is_internal")
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    @JsonProperty(value="replication_factor")
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @JsonProperty(value="partitions_count")
    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    @Override
    @JsonProperty(value="partitions")
    public Resource.Relationship getPartitions() {
        return this.partitions;
    }

    @Override
    @JsonProperty(value="configs")
    public Resource.Relationship getConfigs() {
        return this.configs;
    }

    @Override
    @JsonProperty(value="partition_reassignments")
    public Resource.Relationship getPartitionReassignments() {
        return this.partitionReassignments;
    }

    @Override
    @JsonProperty(value="authorized_operations")
    public ImmutableSet<Acl.Operation> getAuthorizedOperations() {
        return this.authorizedOperations;
    }

    public String toString() {
        return "TopicData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", topicName=" + this.topicName + ", internal=" + this.internal + ", replicationFactor=" + this.replicationFactor + ", partitionsCount=" + this.partitionsCount + ", partitions=" + this.partitions + ", configs=" + this.configs + ", partitionReassignments=" + this.partitionReassignments + ", authorizedOperations=" + this.authorizedOperations + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicData) {
            TopicData that = (TopicData)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.topicName.equals(that.getTopicName()) && this.internal == that.isInternal() && this.replicationFactor == that.getReplicationFactor() && this.partitionsCount == that.getPartitionsCount() && this.partitions.equals(that.getPartitions()) && this.configs.equals(that.getConfigs()) && this.partitionReassignments.equals(that.getPartitionReassignments()) && this.authorizedOperations.equals(that.getAuthorizedOperations());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.internal ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.replicationFactor;
        h$ *= 1000003;
        h$ ^= this.partitionsCount;
        h$ *= 1000003;
        h$ ^= this.partitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.configs.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionReassignments.hashCode();
        h$ *= 1000003;
        return h$ ^= this.authorizedOperations.hashCode();
    }

    static final class Builder
    extends TopicData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private String topicName;
        private Boolean internal;
        private Integer replicationFactor;
        private Integer partitionsCount;
        private Resource.Relationship partitions;
        private Resource.Relationship configs;
        private Resource.Relationship partitionReassignments;
        private ImmutableSet<Acl.Operation> authorizedOperations;

        Builder() {
        }

        @Override
        public TopicData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public TopicData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public TopicData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public TopicData.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public TopicData.Builder setInternal(boolean internal) {
            this.internal = internal;
            return this;
        }

        @Override
        public TopicData.Builder setReplicationFactor(int replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        @Override
        public TopicData.Builder setPartitionsCount(int partitionsCount) {
            this.partitionsCount = partitionsCount;
            return this;
        }

        @Override
        public TopicData.Builder setPartitions(Resource.Relationship partitions) {
            if (partitions == null) {
                throw new NullPointerException("Null partitions");
            }
            this.partitions = partitions;
            return this;
        }

        @Override
        public TopicData.Builder setConfigs(Resource.Relationship configs) {
            if (configs == null) {
                throw new NullPointerException("Null configs");
            }
            this.configs = configs;
            return this;
        }

        @Override
        public TopicData.Builder setPartitionReassignments(Resource.Relationship partitionReassignments) {
            if (partitionReassignments == null) {
                throw new NullPointerException("Null partitionReassignments");
            }
            this.partitionReassignments = partitionReassignments;
            return this;
        }

        @Override
        public TopicData.Builder setAuthorizedOperations(Set<Acl.Operation> authorizedOperations) {
            this.authorizedOperations = ImmutableSet.copyOf(authorizedOperations);
            return this;
        }

        @Override
        public TopicData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.topicName == null) {
                missing = missing + " topicName";
            }
            if (this.internal == null) {
                missing = missing + " internal";
            }
            if (this.replicationFactor == null) {
                missing = missing + " replicationFactor";
            }
            if (this.partitionsCount == null) {
                missing = missing + " partitionsCount";
            }
            if (this.partitions == null) {
                missing = missing + " partitions";
            }
            if (this.configs == null) {
                missing = missing + " configs";
            }
            if (this.partitionReassignments == null) {
                missing = missing + " partitionReassignments";
            }
            if (this.authorizedOperations == null) {
                missing = missing + " authorizedOperations";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TopicData(this.kind, this.metadata, this.clusterId, this.topicName, this.internal, this.replicationFactor, this.partitionsCount, this.partitions, this.configs, this.partitionReassignments, this.authorizedOperations);
        }
    }
}

