/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.ClusterConfig;
import io.confluent.kafkarest.entities.ConfigSource;
import io.confluent.kafkarest.entities.v3.AbstractConfigData;
import io.confluent.kafkarest.entities.v3.AutoValue_ClusterConfigData;
import io.confluent.kafkarest.entities.v3.ConfigSynonymData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
public abstract class ClusterConfigData
extends AbstractConfigData {
    ClusterConfigData() {
    }

    @JsonProperty(value="config_type")
    public abstract ClusterConfig.Type getConfigType();

    public static Builder builder() {
        return new AutoValue_ClusterConfigData.Builder().setKind("KafkaClusterConfig");
    }

    public static Builder fromClusterConfig(ClusterConfig config) {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ClusterConfigData.builder().setClusterId(config.getClusterId())).setConfigType(config.getType()).setName(config.getName())).setValue(config.getValue())).setDefault(config.isDefault())).setReadOnly(config.isReadOnly())).setSensitive(config.isSensitive())).setSource(config.getSource())).setSynonyms(config.getSynonyms().stream().map(ConfigSynonymData::fromConfigSynonym).collect(Collectors.toList()));
    }

    @JsonCreator
    static ClusterConfigData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="config_type") ClusterConfig.Type configType, @JsonProperty(value="name") String name, @JsonProperty(value="value") @Nullable String value, @JsonProperty(value="is_default") boolean isDefault, @JsonProperty(value="is_read_only") boolean isReadOnly, @JsonProperty(value="is_sensitive") boolean isSensitive, @JsonProperty(value="source") ConfigSource source, @JsonProperty(value="synonyms") List<ConfigSynonymData> synonyms) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ClusterConfigData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId)).setConfigType(configType).setName(name)).setValue(value)).setDefault(isDefault)).setReadOnly(isReadOnly)).setSensitive(isSensitive)).setSource(source)).setSynonyms(synonyms)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends AbstractConfigData.Builder<Builder> {
        public abstract Builder setConfigType(ClusterConfig.Type var1);

        public abstract ClusterConfigData build();
    }
}

