/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.exceptions;

import io.confluent.rest.RestConfig;
import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.KafkaExceptionMapper;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.errors.SerializationException;

public final class KafkaRestExceptionMapper
extends KafkaExceptionMapper {
    public KafkaRestExceptionMapper(RestConfig restConfig) {
        super(restConfig);
    }

    public Response toResponse(Throwable exception) {
        if (exception instanceof SerializationException) {
            return this.getResponse(exception, Response.Status.REQUEST_TIMEOUT, 40801);
        }
        return super.toResponse(exception);
    }

    private Response getResponse(Throwable exception, Response.Status status, int errorCode) {
        ErrorMessage errorMessage = new ErrorMessage(errorCode, exception.getMessage());
        return Response.status((Response.Status)status).entity((Object)errorMessage).build();
    }
}

