/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.ratelimit;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.ratelimit.DoNotRateLimit;
import io.confluent.kafkarest.ratelimit.FixedCostRateLimitRequestFilter;
import io.confluent.kafkarest.ratelimit.NullContainerRequestFilter;
import io.confluent.kafkarest.ratelimit.RateLimitModule;
import io.confluent.kafkarest.ratelimit.RequestRateLimiter;
import io.confluent.kafkarest.ratelimit.RequestRateLimiterCacheLoader;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;

final class FixedCostRateLimitFeature
implements DynamicFeature {
    private final Map<String, Integer> costs;
    private final int defaultCost;
    private final RequestRateLimiter genericRateLimiter;
    private final LoadingCache<String, RequestRateLimiter> perClusterRateLimiterCache;

    @Inject
    FixedCostRateLimitFeature(@ConfigModule.RateLimitCostsConfig Map<String, Integer> costs, @ConfigModule.RateLimitDefaultCostConfig Integer defaultCost, @ConfigModule.RateLimitPerClusterCacheExpiryConfig Duration rateLimitPerClusterCacheExpiryConfig, @RateLimitModule.RequestRateLimiterGeneric RequestRateLimiter genericRateLimiter, @RateLimitModule.RequestRateLimiterPerCluster Provider<RequestRateLimiter> perClusterRateLimiterProvider) {
        this.costs = Objects.requireNonNull(costs);
        this.defaultCost = defaultCost;
        this.genericRateLimiter = Objects.requireNonNull(genericRateLimiter);
        this.perClusterRateLimiterCache = CacheBuilder.newBuilder().expireAfterAccess(rateLimitPerClusterCacheExpiryConfig).build((CacheLoader)new RequestRateLimiterCacheLoader(perClusterRateLimiterProvider));
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        int cost = this.getCost(resourceInfo);
        if (cost == 0) {
            context.register((Object)new NullContainerRequestFilter());
        } else {
            context.register((Object)new FixedCostRateLimitRequestFilter(this.genericRateLimiter, cost, this.perClusterRateLimiterCache));
        }
    }

    private int getCost(ResourceInfo resourceInfo) {
        DoNotRateLimit methodIgnore = resourceInfo.getResourceMethod().getAnnotation(DoNotRateLimit.class);
        if (methodIgnore != null) {
            return 0;
        }
        DoNotRateLimit classIgnore = resourceInfo.getResourceClass().getAnnotation(DoNotRateLimit.class);
        if (classIgnore != null) {
            return 0;
        }
        ResourceAccesslistFeature.ResourceName methodName = resourceInfo.getResourceMethod().getAnnotation(ResourceAccesslistFeature.ResourceName.class);
        if (methodName != null && this.costs.containsKey(methodName.value())) {
            return this.costs.get(methodName.value());
        }
        ResourceAccesslistFeature.ResourceName className = resourceInfo.getResourceClass().getAnnotation(ResourceAccesslistFeature.ResourceName.class);
        if (className != null && this.costs.containsKey(className.value())) {
            return this.costs.get(className.value());
        }
        return this.defaultCost;
    }
}

