/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.ratelimit;

import com.google.common.util.concurrent.RateLimiter;
import io.confluent.kafkarest.ratelimit.RateLimitExceededException;
import io.confluent.kafkarest.ratelimit.RequestRateLimiter;
import java.time.Duration;
import java.util.Objects;

final class GuavaRateLimiter
extends RequestRateLimiter {
    private final RateLimiter delegate;
    private final Duration timeout;

    private GuavaRateLimiter(RateLimiter delegate, Duration timeout) {
        this.delegate = Objects.requireNonNull(delegate);
        this.timeout = Objects.requireNonNull(timeout);
    }

    static GuavaRateLimiter create(int permitsPerSecond, Duration timeout) {
        return new GuavaRateLimiter(RateLimiter.create((double)permitsPerSecond), timeout);
    }

    @Override
    public void rateLimit(int cost) {
        if (!this.delegate.tryAcquire(cost, this.timeout)) {
            throw new RateLimitExceededException();
        }
    }
}

