/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v2;

import io.confluent.kafkarest.controllers.BrokerManager;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.v2.BrokerList;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/brokers")
@Produces(value={"application/vnd.kafka.v2+json; qs=0.9"})
@Consumes
@ResourceAccesslistFeature.ResourceName(value="api.v2.brokers.*")
public final class BrokersResource {
    private final Provider<BrokerManager> brokerManager;

    @Inject
    BrokersResource(Provider<BrokerManager> brokerManager) {
        this.brokerManager = Objects.requireNonNull(brokerManager);
    }

    @GET
    @PerformanceMetric(value="brokers.list+v2")
    @ResourceAccesslistFeature.ResourceName(value="api.v2.brokers.list")
    public void list(@Suspended AsyncResponse asyncResponse) {
        CompletionStage response = ((BrokerManager)this.brokerManager.get()).listLocalBrokers().thenApply(brokers -> new BrokerList(brokers.stream().map(Broker::getBrokerId).collect(Collectors.toList())));
        AsyncResponses.asyncResume(asyncResponse, response);
    }
}

