/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.TopicConfigManager;
import io.confluent.kafkarest.entities.v3.AlterTopicConfigBatchRequest;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/configs:alter")
@ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.*")
public final class AlterTopicConfigBatchAction {
    private final Provider<TopicConfigManager> topicConfigManager;

    @Inject
    public AlterTopicConfigBatchAction(Provider<TopicConfigManager> topicConfigManager) {
        this.topicConfigManager = Objects.requireNonNull(topicConfigManager);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.configs.alter")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.alter")
    public void alterTopicConfigBatch(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @Valid AlterTopicConfigBatchRequest request) {
        boolean validateOnly = request.getValue().getValidateOnly().orElse(false);
        CompletableFuture<Void> response = validateOnly ? ((TopicConfigManager)this.topicConfigManager.get()).alterTopicConfigs(clusterId, topicName, request.getValue().toAlterConfigCommands(), true) : ((TopicConfigManager)this.topicConfigManager.get()).alterTopicConfigs(clusterId, topicName, request.getValue().toAlterConfigCommands());
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }
}

