/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.BrokerManager;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.v3.BrokerData;
import io.confluent.kafkarest.entities.v3.BrokerDataList;
import io.confluent.kafkarest.entities.v3.GetBrokerResponse;
import io.confluent.kafkarest.entities.v3.ListBrokersResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/brokers")
@ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.*")
public final class BrokersResource {
    private final Provider<BrokerManager> brokerManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public BrokersResource(Provider<BrokerManager> brokerManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.brokerManager = Objects.requireNonNull(brokerManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.list")
    public void listBrokers(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((BrokerManager)this.brokerManager.get()).listBrokers(clusterId).thenApply(brokers -> ListBrokersResponse.create((BrokerDataList)((BrokerDataList.Builder)((BrokerDataList.Builder)BrokerDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "brokers")).build())).setData(brokers.stream().map(this::toBrokerData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{brokerId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.get")
    public void getBroker(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") Integer brokerId) {
        CompletionStage response = ((CompletableFuture)((BrokerManager)this.brokerManager.get()).getBroker(clusterId, brokerId).thenApply(broker -> (Broker)broker.orElseThrow(NotFoundException::new))).thenApply(broker -> GetBrokerResponse.create(this.toBrokerData((Broker)broker)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private BrokerData toBrokerData(Broker broker) {
        return ((BrokerData.Builder)BrokerData.fromBroker(broker).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", broker.getClusterId(), "brokers", Integer.toString(broker.getBrokerId()))).setResourceName(this.crnFactory.create("kafka", broker.getClusterId(), "broker", Integer.toString(broker.getBrokerId()))).build())).setConfigs(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", broker.getClusterId(), "brokers", Integer.toString(broker.getBrokerId()), "configs"))).setPartitionReplicas(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", broker.getClusterId(), "brokers", Integer.toString(broker.getBrokerId()), "partition-replicas"))).build();
    }
}

