/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ConsumerGroupLagSummaryManager;
import io.confluent.kafkarest.entities.ConsumerGroupLagSummary;
import io.confluent.kafkarest.entities.v3.ConsumerGroupLagSummaryData;
import io.confluent.kafkarest.entities.v3.GetConsumerGroupLagSummaryResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/consumer-groups/{consumerGroupId}/lag-summary")
@ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-group-lag-summary.*")
public final class ConsumerGroupLagSummariesResource {
    private final Provider<ConsumerGroupLagSummaryManager> consumerGroupLagSummaryManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ConsumerGroupLagSummariesResource(Provider<ConsumerGroupLagSummaryManager> consumerGroupLagSummaryManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.consumerGroupLagSummaryManager = Objects.requireNonNull(consumerGroupLagSummaryManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumer-group-lag-summary.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-group-lag-summary.get")
    public void getConsumerGroupLagSummary(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId) {
        CompletionStage response = ((CompletableFuture)((ConsumerGroupLagSummaryManager)this.consumerGroupLagSummaryManager.get()).getConsumerGroupLagSummary(clusterId, consumerGroupId).thenApply(groupLagSummary -> (ConsumerGroupLagSummary)groupLagSummary.orElseThrow(NotFoundException::new))).thenApply(groupLagSummary -> GetConsumerGroupLagSummaryResponse.create(this.toConsumerGroupLagSummaryData((ConsumerGroupLagSummary)groupLagSummary)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ConsumerGroupLagSummaryData toConsumerGroupLagSummaryData(ConsumerGroupLagSummary groupLagSummary) {
        return ((ConsumerGroupLagSummaryData.Builder)ConsumerGroupLagSummaryData.fromConsumerGroupLagSummary(groupLagSummary).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", groupLagSummary.getClusterId(), "consumer-groups", groupLagSummary.getConsumerGroupId(), "lag-summary")).setResourceName(this.crnFactory.create("kafka", groupLagSummary.getClusterId(), "consumer-group", groupLagSummary.getConsumerGroupId(), "lag-summary", null)).build())).setMaxLagConsumer(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", groupLagSummary.getClusterId(), "consumer-groups", groupLagSummary.getConsumerGroupId(), "consumers", groupLagSummary.getMaxLagConsumerId()))).setMaxLagPartition(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", groupLagSummary.getClusterId(), "topics", groupLagSummary.getMaxLagTopicName(), "partitions", Integer.toString(groupLagSummary.getMaxLagPartitionId())))).build();
    }
}

