/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ReassignmentManager;
import io.confluent.kafkarest.entities.Reassignment;
import io.confluent.kafkarest.entities.v3.GetReassignmentResponse;
import io.confluent.kafkarest.entities.v3.ReassignmentData;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/partitions/{partitionId}/reassignment")
@ResourceAccesslistFeature.ResourceName(value="api.v3.partition-reassignments.*")
public final class GetReassignmentAction {
    private final Provider<ReassignmentManager> reassignmentManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public GetReassignmentAction(Provider<ReassignmentManager> reassignmentManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.reassignmentManager = Objects.requireNonNull(reassignmentManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.partitions.reassignment.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.partition-reassignments.get")
    public void getReassignment(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") Integer partitionId) {
        CompletionStage response = ((CompletableFuture)((ReassignmentManager)this.reassignmentManager.get()).getReassignment(clusterId, topicName, partitionId).thenApply(reassignment -> (Reassignment)reassignment.orElseThrow(NotFoundException::new))).thenApply(reassignment -> GetReassignmentResponse.create(this.toReassignmentData((Reassignment)reassignment)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ReassignmentData toReassignmentData(Reassignment reassignment) {
        return ((ReassignmentData.Builder)ReassignmentData.fromReassignment(reassignment).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", reassignment.getClusterId(), "topics", reassignment.getTopicName(), "partitions", Integer.toString(reassignment.getPartitionId()), "reassignment")).setResourceName(this.crnFactory.create("kafka", reassignment.getClusterId(), "topic", reassignment.getTopicName(), "partition", Integer.toString(reassignment.getPartitionId()), "reassignment", null)).build())).setReplicas(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", reassignment.getClusterId(), "topics", reassignment.getTopicName(), "partitions", Integer.toString(reassignment.getPartitionId()), "replicas"))).build();
    }
}

