/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.protobuf.ByteString;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.controllers.ProduceController;
import io.confluent.kafkarest.controllers.RecordSerializer;
import io.confluent.kafkarest.controllers.SchemaManager;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.ProduceResult;
import io.confluent.kafkarest.entities.RegisteredSchema;
import io.confluent.kafkarest.entities.v3.ProduceBatchRequest;
import io.confluent.kafkarest.entities.v3.ProduceBatchRequestEntry;
import io.confluent.kafkarest.entities.v3.ProduceBatchResponse;
import io.confluent.kafkarest.entities.v3.ProduceBatchResponseFailureEntry;
import io.confluent.kafkarest.entities.v3.ProduceBatchResponseSuccessEntry;
import io.confluent.kafkarest.entities.v3.ProduceRequest;
import io.confluent.kafkarest.entities.v3.ProduceResponse;
import io.confluent.kafkarest.exceptions.BadRequestException;
import io.confluent.kafkarest.exceptions.StacklessCompletionException;
import io.confluent.kafkarest.exceptions.v3.ErrorResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.ratelimit.DoNotRateLimit;
import io.confluent.kafkarest.ratelimit.RateLimitExceededException;
import io.confluent.kafkarest.resources.v3.ProduceRateLimiters;
import io.confluent.kafkarest.resources.v3.ProducerMetrics;
import io.confluent.kafkarest.resources.v3.V3ResourcesModule;
import io.confluent.kafkarest.response.StreamingResponse;
import io.confluent.rest.annotations.PerformanceMetric;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collector;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.apache.kafka.common.errors.SerializationException;

@DoNotRateLimit
@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/records:batch")
@ResourceAccesslistFeature.ResourceName(value="api.v3.batch-produce.*")
public final class ProduceBatchAction {
    public static final int BATCH_ID_MINIMUM_LENGTH = 1;
    public static final int BATCH_ID_MAXIMUM_LENGTH = 80;
    @Context
    private Providers providers;
    private static final Collector<ProduceRequest.ProduceRequestHeader, ImmutableMultimap.Builder<String, Optional<ByteString>>, ImmutableMultimap<String, Optional<ByteString>>> PRODUCE_REQUEST_HEADER_COLLECTOR = Collector.of(ImmutableMultimap::builder, (builder, header) -> builder.put((Object)header.getName(), header.getValue()), (left, right) -> left.putAll((Multimap)right.build()), ImmutableMultimap.Builder::build, new Collector.Characteristics[0]);
    private final Provider<SchemaManager> schemaManagerProvider;
    private final Provider<RecordSerializer> recordSerializerProvider;
    private final Provider<ProduceController> produceControllerProvider;
    private final Provider<ProducerMetrics> producerMetricsProvider;
    private final ProduceRateLimiters produceRateLimiters;
    private final int produceBatchMaximumEntries;
    private final ExecutorService executorService;
    @Context
    private HttpServletRequest httpServletRequest;

    @Inject
    public ProduceBatchAction(Provider<SchemaManager> schemaManagerProvider, Provider<RecordSerializer> recordSerializer, Provider<ProduceController> produceControllerProvider, Provider<ProducerMetrics> producerMetrics, ProduceRateLimiters produceRateLimiters, @ConfigModule.ProduceBatchMaximumEntriesConfig Integer produceBatchMaximumEntries, @V3ResourcesModule.ProduceResponseThreadPool ExecutorService executorService) {
        this.schemaManagerProvider = Objects.requireNonNull(schemaManagerProvider);
        this.recordSerializerProvider = Objects.requireNonNull(recordSerializer);
        this.produceControllerProvider = Objects.requireNonNull(produceControllerProvider);
        this.producerMetricsProvider = Objects.requireNonNull(producerMetrics);
        this.produceRateLimiters = Objects.requireNonNull(produceRateLimiters);
        this.produceBatchMaximumEntries = Objects.requireNonNull(produceBatchMaximumEntries);
        this.executorService = Objects.requireNonNull(executorService);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.produce.produce-to-topic")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.batch-produce.produce-to-topic")
    public void produce(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @Valid ProduceBatchRequest request) throws Exception {
        if (request == null) {
            throw Errors.produceBatchException("Request body is empty. Data is required.");
        }
        HashSet entrySet = new HashSet();
        request.getEntries().stream().forEach(e -> {
            if (!entrySet.add(e.getId().textValue())) {
                throw Errors.produceBatchException("Batch entry IDs are not distinct.");
            }
        });
        int batchSize = request.getEntries().size();
        if (batchSize == 0) {
            throw Errors.produceBatchException("Empty batch.");
        }
        if (batchSize > this.produceBatchMaximumEntries) {
            throw Errors.produceBatchException("Too many entries in batch.");
        }
        ArrayList successes = new ArrayList(batchSize);
        ArrayList failures = new ArrayList(batchSize);
        ProduceController controller = (ProduceController)this.produceControllerProvider.get();
        ArrayList<CompletableFuture<ProduceBatchResponseSuccessEntry>> responseFutures = new ArrayList<CompletableFuture<ProduceBatchResponseSuccessEntry>>(batchSize);
        for (ProduceBatchRequestEntry e2 : request.getEntries()) {
            responseFutures.add(this.produce(clusterId, topicName, e2, controller, (ProducerMetrics)this.producerMetricsProvider.get()));
        }
        CompletableFuture.allOf(responseFutures.toArray(new CompletableFuture[0])).whenCompleteAsync((result, error) -> {
            for (int i = 0; i < batchSize; ++i) {
                CompletableFuture future = (CompletableFuture)responseFutures.get(i);
                String entryId = ((ProduceBatchRequestEntry)request.getEntries().get(i)).getId().textValue();
                future.handle((responseResult, responseError) -> {
                    if (responseError != null) {
                        failures.add(this.toErrorEntryForException(entryId, (Throwable)responseError));
                    } else {
                        successes.add(responseResult);
                    }
                    return null;
                });
            }
            asyncResponse.resume((Object)Response.status((int)207, (String)"Multi-Status").entity((Object)ProduceBatchResponse.builder().setSuccesses(successes).setFailures(failures).build()).build());
        }, (Executor)this.executorService);
    }

    private CompletableFuture<ProduceBatchResponseSuccessEntry> produce(String clusterId, String topicName, ProduceBatchRequestEntry request, ProduceController controller, ProducerMetrics metrics) {
        long requestStartNs = System.nanoTime();
        try {
            try {
                this.produceRateLimiters.rateLimit(clusterId, request.getOriginalSize(), this.httpServletRequest);
            }
            catch (RateLimitExceededException e) {
                this.recordRateLimitedMetrics(metrics);
                throw new StacklessCompletionException(e);
            }
            this.recordRequestMetrics(metrics, request.getOriginalSize());
            request.getPartitionId().ifPresent(partitionId -> {
                if (partitionId < 0) {
                    throw Errors.partitionNotFoundException();
                }
            });
            Optional<RegisteredSchema> keySchema = request.getKey().flatMap(key -> this.getSchema(topicName, true, (ProduceRequest.ProduceRequestData)key));
            Optional<EmbeddedFormat> keyFormat = keySchema.map(schema -> Optional.of(schema.getFormat())).orElse(request.getKey().flatMap(ProduceRequest.ProduceRequestData::getFormat));
            Optional<ByteString> serializedKey = this.serialize(topicName, keyFormat, keySchema, request.getKey(), true);
            Optional<RegisteredSchema> valueSchema = request.getValue().flatMap(value -> this.getSchema(topicName, false, (ProduceRequest.ProduceRequestData)value));
            Optional<EmbeddedFormat> valueFormat = valueSchema.map(schema -> Optional.of(schema.getFormat())).orElse(request.getValue().flatMap(ProduceRequest.ProduceRequestData::getFormat));
            Optional<ByteString> serializedValue = this.serialize(topicName, valueFormat, valueSchema, request.getValue(), false);
            CompletableFuture<ProduceResult> produceResult = controller.produce(clusterId, topicName, request.getPartitionId(), (Multimap<String, Optional<ByteString>>)((Multimap)request.getHeaders().stream().collect(PRODUCE_REQUEST_HEADER_COLLECTOR)), serializedKey, serializedValue, request.getTimestamp().orElse(Instant.now()));
            return ((CompletableFuture)produceResult.handleAsync((result, error) -> {
                if (error != null) {
                    long latency = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - requestStartNs);
                    this.recordErrorMetrics(metrics, latency);
                    throw new StacklessCompletionException((Throwable)error);
                }
                return result;
            }, (Executor)this.executorService)).thenApplyAsync(result -> {
                ProduceBatchResponseSuccessEntry batchResult = ProduceBatchAction.toResponseSuccessEntry(request.getId().textValue(), clusterId, topicName, keyFormat, keySchema, valueFormat, valueSchema, result);
                long latency = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - requestStartNs);
                this.recordResponseMetrics(metrics, latency);
                return batchResult;
            }, (Executor)this.executorService);
        }
        catch (Throwable t) {
            CompletableFuture<ProduceBatchResponseSuccessEntry> failedResult = new CompletableFuture<ProduceBatchResponseSuccessEntry>();
            failedResult.completeExceptionally(t);
            return failedResult;
        }
    }

    private Optional<RegisteredSchema> getSchema(String topicName, boolean isKey, ProduceRequest.ProduceRequestData data) {
        if (data.getFormat().isPresent() && !data.getFormat().get().requiresSchema()) {
            return Optional.empty();
        }
        try {
            return Optional.of(((SchemaManager)this.schemaManagerProvider.get()).getSchema(topicName, data.getFormat(), data.getSubject(), data.getSubjectNameStrategy().map(Function.identity()), data.getSchemaId(), data.getSchemaVersion(), data.getRawSchema(), isKey));
        }
        catch (SerializationException se) {
            throw Errors.messageSerializationException(se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), iae);
        }
    }

    private Optional<ByteString> serialize(String topicName, Optional<EmbeddedFormat> format, Optional<RegisteredSchema> schema, Optional<ProduceRequest.ProduceRequestData> data, boolean isKey) {
        return ((RecordSerializer)this.recordSerializerProvider.get()).serialize(format.orElse(EmbeddedFormat.BINARY), topicName, schema, data.map(ProduceRequest.ProduceRequestData::getData).orElse((JsonNode)NullNode.getInstance()), isKey);
    }

    private static ProduceBatchResponseSuccessEntry toResponseSuccessEntry(String id, String clusterId, String topicName, Optional<EmbeddedFormat> keyFormat, Optional<RegisteredSchema> keySchema, Optional<EmbeddedFormat> valueFormat, Optional<RegisteredSchema> valueSchema, ProduceResult result) {
        return ProduceBatchResponseSuccessEntry.builder().setId(id).setClusterId(clusterId).setTopicName(topicName).setPartitionId(result.getPartitionId()).setOffset(result.getOffset()).setTimestamp(result.getTimestamp()).setKey(keyFormat.map(format -> ProduceResponse.ProduceResponseData.builder().setType(keyFormat).setSubject(keySchema.map(RegisteredSchema::getSubject)).setSchemaId(keySchema.map(RegisteredSchema::getSchemaId)).setSchemaVersion(keySchema.map(RegisteredSchema::getSchemaVersion)).setSize(result.getSerializedKeySize()).build())).setValue(valueFormat.map(format -> ProduceResponse.ProduceResponseData.builder().setType(valueFormat).setSubject(valueSchema.map(RegisteredSchema::getSubject)).setSchemaId(valueSchema.map(RegisteredSchema::getSchemaId)).setSchemaVersion(valueSchema.map(RegisteredSchema::getSchemaVersion)).setSize(result.getSerializedValueSize()).build())).build();
    }

    private ProduceBatchResponseFailureEntry toErrorEntryForException(String id, Throwable t) {
        ErrorResponse errorResponse = t instanceof CompletionException ? StreamingResponse.toErrorResponse(((CompletionException)t).getCause()) : StreamingResponse.toErrorResponse(t);
        ProduceBatchResponseFailureEntry.Builder builder = ProduceBatchResponseFailureEntry.builder();
        builder.setId(id);
        builder.setErrorCode(errorResponse.getErrorCode());
        builder.setMessage(errorResponse.getMessage());
        return builder.build();
    }

    private void recordResponseMetrics(ProducerMetrics metrics, long latencyMs) {
        metrics.recordResponse();
        metrics.recordRequestLatency(latencyMs);
    }

    private void recordErrorMetrics(ProducerMetrics metrics, long latencyMs) {
        metrics.recordError();
        metrics.recordRequestLatency(latencyMs);
    }

    private void recordRateLimitedMetrics(ProducerMetrics metrics) {
        metrics.recordRateLimited();
    }

    private void recordRequestMetrics(ProducerMetrics metrics, long size) {
        metrics.recordRequest();
        metrics.recordRequestSize(size);
    }
}

