/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.entities.v3.CreateTopicRequest;
import io.confluent.kafkarest.entities.v3.CreateTopicResponse;
import io.confluent.kafkarest.entities.v3.GetTopicResponse;
import io.confluent.kafkarest.entities.v3.ListTopicsResponse;
import io.confluent.kafkarest.entities.v3.PartitionsCountRequest;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.TopicData;
import io.confluent.kafkarest.entities.v3.TopicDataList;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;

@Path(value="/v3/clusters/{clusterId}/topics")
@ResourceAccesslistFeature.ResourceName(value="api.v3.topics.*")
public final class TopicsResource {
    private final Provider<TopicManager> topicManagerProvider;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public TopicsResource(Provider<TopicManager> topicManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.topicManagerProvider = Objects.requireNonNull(topicManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.list")
    public void listTopics(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @QueryParam(value="includeAuthorizedOperations") @DefaultValue(value="false") boolean includeAuthorizedOperations) {
        CompletionStage response = ((TopicManager)this.topicManagerProvider.get()).listTopics(clusterId, includeAuthorizedOperations).thenApply(topics -> ListTopicsResponse.create((TopicDataList)((TopicDataList.Builder)((TopicDataList.Builder)TopicDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "topics")).build())).setData(topics.stream().sorted(Comparator.comparing(io.confluent.kafkarest.entities.Topic::getName)).map(this::toTopicData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{topicName}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.get")
    public void getTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @QueryParam(value="include_authorized_operations") @DefaultValue(value="false") boolean includeAuthorizedOperations) {
        CompletionStage response = ((CompletableFuture)((TopicManager)this.topicManagerProvider.get()).getTopic(clusterId, topicName, includeAuthorizedOperations).thenApply(topic -> (io.confluent.kafkarest.entities.Topic)topic.orElseThrow(NotFoundException::new))).thenApply(topic -> GetTopicResponse.create(this.toTopicData((io.confluent.kafkarest.entities.Topic)topic)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @PATCH
    @Path(value="/{topicName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.partitions")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.partitions")
    public void updatePartitionsCount(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @Valid PartitionsCountRequest partitionsCount) {
        if (partitionsCount == null) {
            throw Errors.invalidPayloadException("Request body is empty. Partitions_count is required.");
        }
        TopicManager topicManager = (TopicManager)this.topicManagerProvider.get();
        CompletionStage response = topicManager.updateTopicPartitionsCount(topicName, partitionsCount.getPartitionsCount()).thenCompose(nothing -> topicManager.getTopic(clusterId, topicName).thenApply(topic -> GetTopicResponse.create(this.toTopicData((io.confluent.kafkarest.entities.Topic)topic.get()))));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.create")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.create")
    public void createTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @Valid CreateTopicRequest request) {
        if (request == null) {
            throw Errors.invalidPayloadException("Request body is empty. Data is required.");
        }
        String topicName = request.getTopicName();
        try {
            Topic.validate((String)topicName);
        }
        catch (InvalidTopicException e) {
            throw Errors.invalidPayloadException("Invalid topic name.");
        }
        Optional<Integer> partitionsCount = request.getPartitionsCount();
        Optional<Short> replicationFactor = request.getReplicationFactor();
        Map<Integer, List<Integer>> replicasAssignments = request.getReplicasAssignments();
        Map<String, Optional<String>> configs = request.getConfigs().stream().collect(Collectors.toMap(CreateTopicRequest.ConfigEntry::getName, CreateTopicRequest.ConfigEntry::getValue));
        Optional<Integer> requestPartitionsCount = replicasAssignments.isEmpty() ? partitionsCount : Optional.of(replicasAssignments.values().size());
        Optional<Short> requestReplicationFactor = replicasAssignments.isEmpty() ? replicationFactor : Optional.of((short)replicasAssignments.values().iterator().next().size());
        short assumedReplicationFactor = replicationFactor.orElse(replicasAssignments.isEmpty() ? (short)0 : (short)replicasAssignments.values().iterator().next().size());
        TopicData topicData = this.toTopicData(io.confluent.kafkarest.entities.Topic.create(clusterId, topicName, Collections.emptyList(), assumedReplicationFactor, false, Collections.emptySet()));
        boolean validateOnly = request.getValidateOnly().orElse(false);
        TopicManager topicManager = (TopicManager)this.topicManagerProvider.get();
        CompletionStage response = topicManager.createTopic2(clusterId, topicName, requestPartitionsCount, requestReplicationFactor, replicasAssignments, configs, validateOnly).thenApply(topic -> CreateTopicResponse.create(this.toTopicData((io.confluent.kafkarest.entities.Topic)topic)));
        Response.Status responseStatus = validateOnly ? Response.Status.OK : Response.Status.CREATED;
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)responseStatus).location(URI.create(topicData.getMetadata().getSelf()))).entity(response).asyncResume(asyncResponse);
    }

    @DELETE
    @Path(value="/{topicName}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.delete")
    public void deleteTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName) {
        CompletableFuture<Void> response = ((TopicManager)this.topicManagerProvider.get()).deleteTopic(clusterId, topicName);
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    private TopicData toTopicData(io.confluent.kafkarest.entities.Topic topic) {
        return ((TopicData.Builder)TopicData.fromTopic(topic).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", topic.getClusterId(), "topics", topic.getName())).setResourceName(this.crnFactory.create("kafka", topic.getClusterId(), "topic", topic.getName())).build())).setPartitions(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", topic.getClusterId(), "topics", topic.getName(), "partitions"))).setConfigs(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", topic.getClusterId(), "topics", topic.getName(), "configs"))).setPartitionReassignments(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", topic.getClusterId(), "topics", topic.getName(), "partitions", "-", "reassignment"))).build();
    }
}

