/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.response;

import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.response.UrlBuilder;
import io.confluent.kafkarest.response.UrlFactory;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

public final class UrlFactoryImpl
implements UrlFactory {
    private static final char SEPARATOR = '/';
    private final String baseUrl;

    @Inject
    public UrlFactoryImpl(@ConfigModule.HostNameConfig String hostNameConfig, @ConfigModule.PortConfig Integer portConfig, @ConfigModule.AdvertisedListenersConfig List<URI> advertisedListenersConfig, @ConfigModule.ListenersConfig List<URI> listenersConfig, @Context UriInfo requestUriInfo) {
        this.baseUrl = UrlFactoryImpl.computeBaseUrl(hostNameConfig, portConfig, advertisedListenersConfig, listenersConfig, requestUriInfo);
    }

    @Override
    public String create(String ... segments) {
        UrlBuilder urlBuilder = this.newUrlBuilder();
        for (String component : segments) {
            String stripped = UrlFactoryImpl.trimSeparator(component);
            if (stripped.isEmpty()) continue;
            urlBuilder.appendPathSegment(stripped);
        }
        return urlBuilder.build();
    }

    @Override
    public UrlBuilder newUrlBuilder() {
        return new UrlBuilder(this.baseUrl);
    }

    private static String computeBaseUrl(String hostNameConfig, Integer portConfig, List<URI> advertisedListenersConfig, List<URI> listenersConfig, UriInfo requestUriInfo) {
        String scheme = UrlFactoryImpl.computeScheme(requestUriInfo);
        String authority = UrlFactoryImpl.computeAuthority(hostNameConfig, portConfig, advertisedListenersConfig, listenersConfig, requestUriInfo);
        String basePath = UrlFactoryImpl.computeBasePath(requestUriInfo);
        StringBuilder baseUrl = new StringBuilder(scheme).append("://").append(authority);
        if (!basePath.isEmpty()) {
            baseUrl.append('/').append(basePath);
        }
        return baseUrl.toString();
    }

    private static String computeScheme(UriInfo requestUriInfo) {
        return requestUriInfo.getAbsolutePath().getScheme();
    }

    private static String computeAuthority(String hostNameConfig, Integer portConfig, List<URI> advertisedListenersConfig, List<URI> listenersConfig, UriInfo requestUriInfo) {
        return Stream.of(UrlFactoryImpl.computeAuthorityFromAdvertisedListeners(advertisedListenersConfig, requestUriInfo), UrlFactoryImpl.computeAuthorityFromHostNameAndPort(hostNameConfig, portConfig, listenersConfig, requestUriInfo)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(requestUriInfo.getAbsolutePath().getAuthority());
    }

    private static Optional<String> computeAuthorityFromAdvertisedListeners(List<URI> advertisedListenersConfig, UriInfo requestUriInfo) {
        String requestScheme = requestUriInfo.getAbsolutePath().getScheme();
        for (URI listener : advertisedListenersConfig) {
            if (!requestScheme.equals(listener.getScheme())) continue;
            return Optional.of(listener.getAuthority());
        }
        return Optional.empty();
    }

    private static Optional<String> computeAuthorityFromHostNameAndPort(String hostNameConfig, Integer portConfig, List<URI> listenersConfig, UriInfo requestUriInfo) {
        String requestScheme = requestUriInfo.getAbsolutePath().getScheme();
        if (hostNameConfig == null || hostNameConfig.isEmpty()) {
            return Optional.empty();
        }
        int port = -1;
        if (requestUriInfo.getAbsolutePath().getPort() != -1) {
            port = portConfig;
            for (URI listener : listenersConfig) {
                if (!requestScheme.equals(listener.getScheme())) continue;
                port = listener.getPort();
            }
        }
        return Optional.of(String.format("%s%s", hostNameConfig, port != -1 ? ":" + port : ""));
    }

    private static String computeBasePath(UriInfo requestUriInfo) {
        return UrlFactoryImpl.trimSeparator(requestUriInfo.getBaseUri().getPath());
    }

    private static String trimSeparator(String component) {
        int end;
        int beginning;
        for (beginning = 0; beginning < component.length() && component.charAt(beginning) == '/'; ++beginning) {
        }
        for (end = component.length() - 1; end >= 0 && component.charAt(end) == '/'; --end) {
        }
        return beginning <= end ? component.substring(beginning, end + 1) : "";
    }
}

