/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.v2;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.converters.SchemaConverter;
import io.confluent.kafkarest.entities.ConsumerInstanceConfig;
import io.confluent.kafkarest.entities.ConsumerRecord;
import io.confluent.kafkarest.v2.KafkaConsumerState;
import org.apache.kafka.clients.consumer.Consumer;

public final class SchemaKafkaConsumerState
extends KafkaConsumerState<Object, Object, JsonNode, JsonNode> {
    private final SchemaConverter schemaConverter;

    public SchemaKafkaConsumerState(KafkaRestConfig config, ConsumerInstanceConfig consumerInstanceConfig, ConsumerInstanceId instanceId, Consumer consumer, SchemaConverter schemaConverter) {
        super(config, consumerInstanceConfig, instanceId, consumer);
        this.schemaConverter = schemaConverter;
    }

    @Override
    public ConsumerRecordAndSize<JsonNode, JsonNode> createConsumerRecord(org.apache.kafka.clients.consumer.ConsumerRecord<Object, Object> record) {
        SchemaConverter.JsonNodeAndSize keyNode = this.schemaConverter.toJson(record.key());
        SchemaConverter.JsonNodeAndSize valueNode = this.schemaConverter.toJson(record.value());
        return new ConsumerRecordAndSize<JsonNode, JsonNode>(ConsumerRecord.create(record.topic(), keyNode.getJson(), valueNode.getJson(), record.partition(), record.offset()), keyNode.getSize() + valueNode.getSize());
    }
}

