/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.azure;

import com.azure.core.exception.AzureException;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.google.crypto.tink.Aead;
import java.security.GeneralSecurityException;

public final class AzureKmsAead
implements Aead {
    private final CryptographyClient kmsClient;
    private final EncryptionAlgorithm algorithm;

    public AzureKmsAead(CryptographyClient kmsClient, EncryptionAlgorithm algorithm) {
        this.kmsClient = kmsClient;
        this.algorithm = algorithm;
    }

    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        try {
            return this.kmsClient.encrypt(this.algorithm, plaintext).getCipherText();
        }
        catch (AzureException e) {
            throw new GeneralSecurityException("encryption failed", e);
        }
    }

    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        try {
            return this.kmsClient.decrypt(this.algorithm, ciphertext).getPlainText();
        }
        catch (AzureException e) {
            throw new GeneralSecurityException("decryption failed", e);
        }
    }
}

