/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.message.AlterMirrorTopicsResponseData;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineHashSet;
import org.slf4j.Logger;

public class MirrorTopicControlManager {
    private final SnapshotRegistry snapshotRegistry;
    private final Logger log;
    private final Time time;
    private final Function<String, Optional<Uuid>> clusterLinkIdResolver;
    private final Function<Uuid, Optional<ClusterLink>> clusterLinkResolver;
    private final Function<Uuid, Optional<Map<String, String>>> clusterLinkConfigResolver;
    private final Function<String, Optional<Uuid>> topicIdResolver;
    private final TimelineHashMap<Uuid, TimelineHashSet<Uuid>> linksToMirrorTopics;
    private final TimelineHashMap<Uuid, MirrorTopic> mirrorTopics;
    private final FeatureControlManager featureControl;

    public MirrorTopicControlManager(SnapshotRegistry snapshotRegistry, LogContext logContext, Time time, Function<String, Optional<Uuid>> topicIdResolver, Function<String, Optional<Uuid>> clusterLinkIdResolver, Function<Uuid, Optional<ClusterLink>> clusterLinkResolver, Function<Uuid, Optional<Map<String, String>>> clusterLinkConfigResolver, FeatureControlManager featureControl) {
        this.snapshotRegistry = snapshotRegistry;
        this.time = time;
        this.topicIdResolver = topicIdResolver;
        this.clusterLinkIdResolver = clusterLinkIdResolver;
        this.clusterLinkResolver = clusterLinkResolver;
        this.clusterLinkConfigResolver = clusterLinkConfigResolver;
        this.log = logContext.logger(MirrorTopicControlManager.class);
        this.linksToMirrorTopics = new TimelineHashMap(snapshotRegistry, 0);
        this.mirrorTopics = new TimelineHashMap(snapshotRegistry, 0);
        this.featureControl = featureControl;
    }

    boolean isMirrorTopic(Uuid topicId) {
        return this.mirrorTopics.containsKey((Object)topicId);
    }

    Optional<MirrorTopic> mirrorTopic(Uuid topicId) {
        return Optional.ofNullable(this.mirrorTopics.get((Object)topicId));
    }

    Optional<MirrorTopic> mirrorTopic(String topicName) {
        Optional<Uuid> topicId = this.topicIdResolver.apply(topicName);
        if (topicId.isPresent()) {
            return this.mirrorTopic(topicId.get());
        }
        return Optional.empty();
    }

    boolean isMirrorTopic(String topicName) {
        Optional<Uuid> topicId = this.topicIdResolver.apply(topicName);
        return topicId.filter(this::isMirrorTopic).isPresent();
    }

    Optional<Uuid> clusterLinkIdForTopicId(Uuid topicId) {
        return Optional.ofNullable(this.mirrorTopics.get((Object)topicId)).map(MirrorTopic::linkId);
    }

    Set<Uuid> topicIdsForClusterLinkId(Uuid linkId, boolean excludeStopped) {
        Set topicIds = (Set)this.linksToMirrorTopics.get((Object)linkId);
        if (topicIds == null) {
            return Collections.emptySet();
        }
        if (excludeStopped) {
            return topicIds.stream().filter(topicId -> !((MirrorTopic)this.mirrorTopics.get(topicId)).mirrorState().equals((Object)MirrorTopic.State.STOPPED)).collect(Collectors.toSet());
        }
        return topicIds;
    }

    Set<String> topicsInUse(Uuid linkId) {
        Set topicIds = (Set)this.linksToMirrorTopics.get((Object)linkId);
        if (topicIds == null) {
            return Collections.emptySet();
        }
        return topicIds.stream().filter(topicId -> {
            MirrorTopic.State state = ((MirrorTopic)this.mirrorTopics.get(topicId)).mirrorState();
            return state != MirrorTopic.State.STOPPED;
        }).map(topicId -> ((MirrorTopic)this.mirrorTopics.get(topicId)).topicName()).collect(Collectors.toSet());
    }

    ControllerResult<AlterMirrorTopicsResponseData> alterMirrorTopics(AlterMirrorTopicsRequestData request) {
        BoundedList records = BoundedList.newArrayBacked((int)10000);
        AlterMirrorTopicsResponseData response = new AlterMirrorTopicsResponseData();
        response.setAlterMirrorResults(new ArrayList());
        for (AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic : request.alterMirrorTopics()) {
            ApiError error = this.alterMirrorState(alterMirrorTopic, ((List)records)::add);
            AlterMirrorTopicsResponseData.AlterMirrorResult result = new AlterMirrorTopicsResponseData.AlterMirrorResult();
            result.setTopic(result.topic());
            result.setErrorCode(error.error().code());
            result.setErrorMessage(error.message());
            response.alterMirrorResults().add(result);
        }
        response.setErrorCode(Errors.NONE.code());
        if (request.validateOnly()) {
            return ControllerResult.of(Collections.emptyList(), response);
        }
        return ControllerResult.of((List<ApiMessageAndVersion>)records, response);
    }

    ControllerResult<AlterMirrorsResponseData> alterMirrors(ControllerRequestContext context, AlterMirrorsRequest request) {
        Set mirrorTopics;
        Set mirrorTopicIds;
        Set linkIds;
        BoundedList records = BoundedList.newArrayBacked((int)10000);
        AlterMirrorsResponseData response = new AlterMirrorsResponseData();
        response.setResults(new ArrayList());
        Set mirrorOpCodes = request.mirrorOperations().stream().map(AlterMirrorsRequestData.MirrorOperation::operationCode).collect(Collectors.toSet());
        boolean containsReverseAndSwapOpCode = ClusterLinkUtils.containsReverseAndSwapOpCode(mirrorOpCodes);
        if (containsReverseAndSwapOpCode && mirrorOpCodes.size() > 1) {
            throw new InvalidRequestException("Only one mirror operation is allowed when doing reverse and swap operations");
        }
        if (containsReverseAndSwapOpCode && (linkIds = (mirrorTopicIds = (mirrorTopics = request.mirrorOperations().stream().map(AlterMirrorsRequestData.MirrorOperation::topic).collect(Collectors.toSet())).stream().map(this.topicIdResolver).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet())).stream().map(this::clusterLinkIdForTopicId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet())).size() > 1) {
            throw new InvalidRequestException("Reverse and swap operations are only supported on topics that are on the same cluster link");
        }
        Uuid linkId = context.requestHeader().clusterLinkId();
        for (AlterMirrorsRequestData.MirrorOperation op : request.mirrorOperations()) {
            ApiError error = this.alterMirror(op, linkId, ((List)records)::add);
            AlterMirrorsResponseData.AlterMirrorResult result = new AlterMirrorsResponseData.AlterMirrorResult();
            result.setTopic(op.topic());
            result.setErrorCode(error.error().code());
            result.setErrorMessage(error.message());
            response.results().add(result);
        }
        if (request.validateOnly()) {
            return ControllerResult.of(Collections.emptyList(), response);
        }
        return ControllerResult.of((List<ApiMessageAndVersion>)records, response);
    }

    ApiError alterMirror(AlterMirrorsRequestData.MirrorOperation op, Uuid linkId, Consumer<ApiMessageAndVersion> recordConsumer) {
        String topicName = op.topic();
        Topic.validate((String)topicName);
        AlterMirrorOp alterMirrorOp = null;
        try {
            Optional<Uuid> topicId = this.topicIdResolver.apply(topicName);
            if (!topicId.isPresent()) {
                throw new UnknownTopicOrPartitionException("No such topic " + topicName);
            }
            alterMirrorOp = AlterMirrorOp.forId((byte)op.operationCode());
            MirrorTopic currentState = (MirrorTopic)this.mirrorTopics.get((Object)topicId.get());
            Optional<MirrorTopic> newState = this.computeAlteredMirrorState(op, linkId, topicName, alterMirrorOp, currentState);
            short recordVersion = (short)(this.featureControl.metadataVersion().isClusterLinkingFailbackSupported() ? 1 : 0);
            if (newState.isPresent()) {
                if (currentState == null) {
                    recordConsumer.accept(new ApiMessageAndVersion((ApiMessage)MirrorTopic.toSnapshotRecord(newState.get(), topicName), recordVersion));
                } else {
                    recordConsumer.accept(new ApiMessageAndVersion((ApiMessage)MirrorTopic.toChangeRecord(newState.get()), recordVersion));
                }
            }
            return new ApiError(Errors.NONE, "");
        }
        catch (ApiException ex) {
            this.log.info("Encountered error while processing alterMirror operation " + (alterMirrorOp == null ? "null" : alterMirrorOp) + " for topic " + topicName);
            return new ApiError(Errors.forException((Throwable)ex), ex.getMessage());
        }
        catch (Throwable ex) {
            this.log.error("Encountered error while processing alterMirror operation " + (alterMirrorOp == null ? "null" : alterMirrorOp) + " for topic " + topicName);
            return new ApiError(Errors.forException((Throwable)ex), ex.getMessage());
        }
    }

    private Optional<MirrorTopic> computeAlteredMirrorState(AlterMirrorsRequestData.MirrorOperation op, Uuid linkId, String topicName, AlterMirrorOp alterMirrorOp, MirrorTopic currentState) {
        Optional<MirrorTopic> newState;
        boolean isConvertToMirror;
        if (alterMirrorOp == null) {
            throw new InvalidRequestException("Unknown AlterMirror operation code provided for topic " + op.topic());
        }
        boolean bl = isConvertToMirror = alterMirrorOp == AlterMirrorOp.CONVERT_TO_START_PENDING_MIRROR || alterMirrorOp == AlterMirrorOp.CONVERT_TO_PAUSE_PENDING_MIRROR;
        if (currentState == null && !isConvertToMirror) {
            throw new InvalidRequestException("Topic " + op.topic() + " is not a mirror topic.");
        }
        switch (alterMirrorOp) {
            case PROMOTE: {
                newState = this.promoteOrFailoverMirrorTopic(currentState, true);
                break;
            }
            case FAILOVER: {
                newState = this.promoteOrFailoverMirrorTopic(currentState, false);
                break;
            }
            case PAUSE: {
                newState = this.pauseMirrorTopic(currentState, true, false, false);
                break;
            }
            case RESUME: {
                newState = this.pauseMirrorTopic(currentState, false, false, false);
                break;
            }
            case PAUSE_LINK: {
                newState = this.pauseMirrorTopic(currentState, true, true, false);
                break;
            }
            case RESUME_LINK: {
                newState = this.pauseMirrorTopic(currentState, false, true, false);
                break;
            }
            case STOP: {
                if (op.mirrorOperationData() == null || op.mirrorOperationData().stoppedLogEndOffsets() == null) {
                    throw new InvalidRequestException("Invalid stopped log end offsets provided with STOP alter mirror operation");
                }
                List logEndOffsets = op.mirrorOperationData().stoppedLogEndOffsets();
                newState = this.completeStopMirrorTopicOperation(currentState, logEndOffsets);
                break;
            }
            case CLEAR_OFFSETS: {
                newState = this.clearMirrorStartOffsets(currentState);
                break;
            }
            case CONVERT_TO_START_PENDING_MIRROR: {
                this.validateConvertToPendingMirror(topicName, op.mirrorOperationData(), linkId);
                this.validateNoLinkPrefix(linkId);
                newState = this.convertToPendingMirror(currentState, op.mirrorOperationData().sourceTopicId(), linkId, op.mirrorOperationData().expectedLocalTopicId(), topicName, op.mirrorOperationData().sourceTopicName(), MirrorTopic.State.MIRROR);
                break;
            }
            case CONVERT_TO_PAUSE_PENDING_MIRROR: {
                this.validateConvertToPendingMirror(topicName, op.mirrorOperationData(), linkId);
                this.validateNoLinkPrefix(linkId);
                newState = this.convertToPendingMirror(currentState, op.mirrorOperationData().sourceTopicId(), linkId, op.mirrorOperationData().expectedLocalTopicId(), topicName, op.mirrorOperationData().sourceTopicName(), MirrorTopic.State.PAUSED);
                break;
            }
            case START_PENDING_MIRROR: {
                this.validateNoLinkPrefix(linkId);
                newState = this.startPendingMirror(currentState);
                break;
            }
            case PAUSE_PENDING_MIRROR: {
                this.validateNoLinkPrefix(linkId);
                this.validateConvertFromPendingMirror(currentState, MirrorTopic.State.PAUSED);
                newState = this.pauseMirrorTopic(currentState, true, false, true);
                break;
            }
            case FAIL_MIRROR: {
                AlterMirrorsRequestData.MirrorOperationData mirrorOperationData = op.mirrorOperationData();
                if (mirrorOperationData == null) {
                    throw new InvalidRequestException("MirrorOperationData cannot be null when failing mirror");
                }
                newState = this.failMirrorTopic(currentState, mirrorOperationData.mirrorTopicErrorCode());
                break;
            }
            case REPAIR: {
                newState = this.repairMirrorTopic(currentState, false);
                break;
            }
            case COMPLETE_REPAIR: {
                newState = this.repairMirrorTopic(currentState, true);
                break;
            }
            case REVERSE_AND_START_REMOTE_MIRROR: {
                this.validateNoLinkPrefix(currentState.linkId());
                this.validateReverseAndSwapOperation(currentState);
                newState = this.promoteLocalMirrorTopicAndSwapRemoteTopic(currentState, MirrorTopic.State.MIRROR);
                break;
            }
            case REVERSE_AND_PAUSE_REMOTE_MIRROR: {
                this.validateNoLinkPrefix(currentState.linkId());
                this.validateReverseAndSwapOperation(currentState);
                newState = this.promoteLocalMirrorTopicAndSwapRemoteTopic(currentState, MirrorTopic.State.PAUSED);
                break;
            }
            case ROLLBACK: {
                this.validateNotUnsupportedRollbackState(currentState.mirrorState());
                newState = this.rollbackMirror(currentState);
                break;
            }
            case CLEAR: {
                throw new InvalidRequestException("Explicit CLEAR AlterMirror op is unsupported in KRaft mode");
            }
            default: {
                throw new UnsupportedVersionException("Unknown alter mirrors op type for topic " + topicName);
            }
        }
        return newState;
    }

    private void validateNoLinkPrefix(Uuid linkId) {
        Optional<Map<String, String>> configMap = this.clusterLinkConfigResolver.apply(linkId);
        if (!configMap.isPresent()) {
            throw new InvalidRequestException("No config found for cluster link " + linkId);
        }
        String clusterLinkPrefix = configMap.get().get("cluster.link.prefix");
        if (clusterLinkPrefix != null && !clusterLinkPrefix.isEmpty()) {
            throw new InvalidRequestException("Reverse and swap operations are not supported on cluster links with prefixes");
        }
    }

    private void validateReverseAndSwapOperation(MirrorTopic currentState) {
        Optional<ClusterLink> linkInfo = this.clusterLinkResolver.apply(currentState.linkId());
        if (!linkInfo.isPresent()) {
            throw new InvalidRequestException("Link " + currentState.linkName() + " does not exist");
        }
        ClusterLink clusterLink = linkInfo.get();
        if (!clusterLink.linkMode().equals((Object)ClusterLinkConfig.LinkMode.BIDIRECTIONAL)) {
            throw new InvalidRequestException("Reverse and swap operations are only supported on bidirectional links");
        }
        String exceptionMsg = "Check local mirror topic and remote mirror topic for status - you may need to rollback mirroring on local mirror to get back into a good state.";
        ClusterLinkUtils.ensureValidUuid((String)"Link id", (Uuid)currentState.linkId(), (String)exceptionMsg);
        ClusterLinkUtils.ensureValidUuid((String)"Topic id", (Uuid)currentState.topicId(), (String)exceptionMsg);
        ClusterLinkUtils.ensureValidUuid((String)"Source topic id", (Uuid)currentState.sourceTopicId(), (String)exceptionMsg);
    }

    private void validateConvertToPendingMirror(String topicName, AlterMirrorsRequestData.MirrorOperationData mirrorOperationData, Uuid linkId) {
        if (mirrorOperationData == null) {
            throw new InvalidRequestException("Invalid source topic and local topic information provided. Unable to convert to mirror topic.");
        }
        if (linkId == null || linkId.equals((Object)Uuid.ZERO_UUID)) {
            throw new InvalidRequestException("Invalid link id provided to convert topic to mirror");
        }
        Optional<ClusterLink> linkInfo = this.clusterLinkResolver.apply(linkId);
        if (!linkInfo.isPresent()) {
            throw new ClusterLinkNotFoundException("Link not found for id " + linkId + ". Cannot convert the topic to PendingMirror");
        }
        Uuid sourceTopicId = mirrorOperationData.sourceTopicId();
        if (sourceTopicId.equals((Object)Uuid.ZERO_UUID)) {
            throw new InvalidRequestException("Invalid source topic id provided to convert topic to mirror");
        }
        Uuid expectedLocalTopicId = mirrorOperationData.expectedLocalTopicId();
        if (expectedLocalTopicId.equals((Object)Uuid.ZERO_UUID)) {
            throw new InvalidRequestException("Invalid expected local topic id provided to convert topic to mirror");
        }
        if (mirrorOperationData.sourceTopicName() == null) {
            throw new InvalidRequestException("Invalid source topic name provided to convert topic to mirror");
        }
        Optional<Uuid> actualLocalTopicId = this.topicIdResolver.apply(topicName);
        if (!actualLocalTopicId.isPresent()) {
            throw new InvalidRequestException("Topic with topic name " + topicName + " not present on this cluster. Cannot convert topic to mirror");
        }
        if (!actualLocalTopicId.get().equals((Object)expectedLocalTopicId)) {
            throw new InvalidRequestException("Unable to convert " + topicName + " to a PendingMirror state as " + actualLocalTopicId + " does not match the remote mirror topic's persisted source topic id of " + expectedLocalTopicId + " and therefore unable to establish provenance between the two topics.");
        }
    }

    void validateNotUnsupportedRollbackState(MirrorTopic.State currentState) {
        switch (currentState) {
            case PENDING_STOPPED: 
            case PENDING_SYNCHRONIZE: {
                break;
            }
            default: {
                throw new InvalidRequestException("Cannot rollback a topic in an unknown state " + (Object)((Object)currentState));
            }
        }
    }

    private Optional<MirrorTopic> convertToPendingMirror(MirrorTopic currentState, Uuid sourceTopicId, Uuid linkId, Uuid topicId, String topicName, String sourceTopicName, MirrorTopic.State nextState) {
        long timeMs = this.time.milliseconds();
        Optional<ClusterLink> linkInfo = this.clusterLinkResolver.apply(linkId);
        if (!linkInfo.isPresent()) {
            throw new ClusterLinkNotFoundException("Link not found for id " + linkId + ". Cannot convert the topic to PendingMirror");
        }
        if (currentState == null) {
            return Optional.of(new MirrorTopic.PendingMirrorTopic(linkId, linkInfo.get().linkName(), topicId, topicName, sourceTopicId, sourceTopicName, timeMs, nextState));
        }
        if (!nextState.equals((Object)MirrorTopic.State.MIRROR) && !nextState.equals((Object)MirrorTopic.State.PAUSED)) {
            throw new InvalidRequestException("See invalid nextState of " + (Object)((Object)nextState) + ". Only Mirror and PausedMirror states allowed for next state.");
        }
        return currentState.toPendingMirror(sourceTopicId, linkId, timeMs, nextState);
    }

    private Optional<MirrorTopic> startPendingMirror(MirrorTopic currentState) {
        this.validateConvertFromPendingMirror(currentState, MirrorTopic.State.MIRROR);
        long timeMs = this.time.milliseconds();
        return currentState.toMirror(timeMs);
    }

    private void validateConvertFromPendingMirror(MirrorTopic currentState, MirrorTopic.State expectedState) {
        if (!currentState.mirrorState().stateName().equals(MirrorTopic.State.PENDING_MIRROR.stateName())) {
            throw new InvalidRequestException("Cannot convert the PendingMirror topic to PausedMirror since it is in " + currentState.mirrorState().stateName() + " state");
        }
        MirrorTopic.State nextState = ((MirrorTopic.PendingMirrorTopic)currentState).nextState();
        if (!nextState.equals((Object)expectedState)) {
            throw new InvalidRequestException("See invalid nextState of " + (Object)((Object)nextState) + ". Expected " + expectedState.stateName() + " for converting from PendingMirror.");
        }
    }

    private Optional<MirrorTopic> clearMirrorStartOffsets(MirrorTopic currentState) {
        long timeMs = this.time.milliseconds();
        return currentState.clearMirrorStartOffsets(timeMs);
    }

    private Optional<MirrorTopic> completeStopMirrorTopicOperation(MirrorTopic currentState, List<Long> stoppedLogEndOffsets) {
        long timeMs = this.time.milliseconds();
        return currentState.toStopped(stoppedLogEndOffsets, timeMs);
    }

    private Optional<MirrorTopic> pauseMirrorTopic(MirrorTopic currentState, boolean enable, boolean linkLevel, boolean isPausePendingMirror) {
        long timeMs = this.time.milliseconds();
        if (!isPausePendingMirror && currentState.mirrorState().equals((Object)MirrorTopic.State.PENDING_MIRROR)) {
            throw new InvalidRequestException("Cannot pause or resume a PendingMirror");
        }
        if (enable) {
            return currentState.toPaused(linkLevel, timeMs);
        }
        return currentState.toUnpaused(linkLevel, timeMs);
    }

    private Optional<MirrorTopic> failMirrorTopic(MirrorTopic currentState, short mirrorTopicError) {
        long timeMs = this.time.milliseconds();
        return currentState.toFailedMirror(mirrorTopicError, timeMs);
    }

    private Optional<MirrorTopic> promoteOrFailoverMirrorTopic(MirrorTopic currentState, boolean synchronize) {
        long timeMs = this.time.milliseconds();
        return currentState.toPendingStopped(synchronize, timeMs);
    }

    private Optional<MirrorTopic> rollbackMirror(MirrorTopic currentState) {
        Optional<ClusterLink> linkInfo = this.clusterLinkResolver.apply(currentState.linkId());
        if (!linkInfo.isPresent()) {
            throw new InvalidRequestException("Link " + currentState.linkName() + " does not exist");
        }
        long timeMs = this.time.milliseconds();
        return currentState.toMirror(timeMs);
    }

    private Optional<MirrorTopic> repairMirrorTopic(MirrorTopic currentState, boolean completeRepair) {
        long timeMs = this.time.milliseconds();
        if (completeRepair) {
            return currentState.toMirror(timeMs);
        }
        return currentState.toPendingRepair(timeMs);
    }

    private Optional<MirrorTopic> promoteLocalMirrorTopicAndSwapRemoteTopic(MirrorTopic currentState, MirrorTopic.State nextState) {
        long timeMs = this.time.milliseconds();
        return currentState.toPendingSynchronize(nextState, timeMs);
    }

    ApiError alterMirrorState(AlterMirrorTopicsRequestData.AlterMirrorTopic request, Consumer<ApiMessageAndVersion> recordConsumer) {
        MirrorTopic newMirrorTopic;
        MirrorTopic.State newState;
        boolean isNewPendingMirrorTopic;
        String topic = request.topic();
        Optional<Uuid> topicId = this.topicIdResolver.apply(topic);
        if (!topicId.isPresent()) {
            return new ApiError(Errors.UNKNOWN_TOPIC_ID, "No such topic '" + topic + "'.");
        }
        MirrorTopic mirrorTopic = (MirrorTopic)this.mirrorTopics.get((Object)topicId.get());
        boolean bl = isNewPendingMirrorTopic = mirrorTopic == null && request.mirrorTopicState().equals(MirrorTopic.State.PENDING_MIRROR.stateName());
        if (isNewPendingMirrorTopic) {
            Uuid linkId = request.linkId();
            Optional<ClusterLink> clusterLink = this.clusterLinkResolver.apply(linkId);
            if (!clusterLink.isPresent()) {
                return new ApiError(Errors.CLUSTER_LINK_NOT_FOUND, "Cluster link " + linkId + " was not found.");
            }
            Uuid expectedLocalTopicId = request.expectedLocalTopicId();
            if (!expectedLocalTopicId.equals((Object)topicId.get())) {
                return new ApiError(Errors.INVALID_REQUEST, "Unable to convert topic to PendingMirror state as local topic id does not match expected local topic id.");
            }
            String linkName = clusterLink.get().linkName();
            MirrorTopic.State nextState = request.nextState() == null ? null : MirrorTopic.State.fromStateName(request.nextState());
            mirrorTopic = new MirrorTopic.PendingMirrorTopic(linkId, linkName, topicId.get(), topic, request.sourceTopicId(), request.sourceTopicName(), this.time.milliseconds(), nextState);
        } else if (mirrorTopic == null) {
            return new ApiError(Errors.INVALID_REQUEST, "Topic '" + topic + "' is not a mirror topic.");
        }
        try {
            newState = MirrorTopic.State.fromStateName(request.mirrorTopicState());
        }
        catch (IllegalArgumentException e) {
            return new ApiError(Errors.INVALID_REQUEST, "Unknown mirror topic state " + request.mirrorTopicState() + " for mirror topic " + mirrorTopic.topicId());
        }
        if (!this.isAllowedStateChange(mirrorTopic.mirrorState(), newState)) {
            return new ApiError(Errors.INVALID_REQUEST, "Illegal state transition " + (Object)((Object)mirrorTopic.mirrorState()) + " to " + (Object)((Object)newState) + " for mirror topic " + mirrorTopic.topicId());
        }
        long timeMs = this.time.milliseconds();
        switch (newState) {
            case MIRROR: {
                newMirrorTopic = MirrorTopic.mirror(mirrorTopic, timeMs, request.mirrorStartOffsets());
                break;
            }
            case PAUSED: {
                MirrorTopic.State pendingSynchronizeNextState = request.nextState() == null ? null : MirrorTopic.State.fromStateName(request.nextState());
                newMirrorTopic = MirrorTopic.paused(mirrorTopic, timeMs, request.topicLevelPause(), request.linkLevelPause(), mirrorTopic.mirrorState(), mirrorTopic.mirrorStartOffsets(), request.mirrorTopicError(), pendingSynchronizeNextState);
                break;
            }
            case FAILED: {
                newMirrorTopic = MirrorTopic.failed(mirrorTopic, timeMs, request.mirrorTopicError());
                break;
            }
            case PENDING_SYNCHRONIZE: {
                MirrorTopic.State nextMirrorState = request.nextState() == null ? null : MirrorTopic.State.fromStateName(request.nextState());
                newMirrorTopic = MirrorTopic.pendingSynchronize(mirrorTopic, timeMs, nextMirrorState);
                break;
            }
            case PENDING_STOPPED: {
                newMirrorTopic = MirrorTopic.pendingStopped(mirrorTopic, timeMs, request.promoted());
                break;
            }
            case PENDING_MIRROR: {
                MirrorTopic.State nextState = request.nextState() == null ? null : MirrorTopic.State.fromStateName(request.nextState());
                newMirrorTopic = MirrorTopic.pendingMirror(mirrorTopic, timeMs, nextState, request.sourceTopicId());
                break;
            }
            case STOPPED: {
                newMirrorTopic = MirrorTopic.stopped(mirrorTopic, timeMs, request.stoppedLogEndOffsets());
                break;
            }
            case PENDING_REPAIR: {
                newMirrorTopic = MirrorTopic.pendingRepairMirror(mirrorTopic, timeMs, request.mirrorTopicError());
                break;
            }
            default: {
                return new ApiError(Errors.INVALID_REQUEST, "Cannot transition mirror topic " + mirrorTopic.topicId() + " from " + (Object)((Object)mirrorTopic.mirrorState()) + " to unknown state " + request.mirrorTopicState());
            }
        }
        short recordVersion = (short)(this.featureControl.metadataVersion().isClusterLinkingFailbackSupported() ? 1 : 0);
        if (isNewPendingMirrorTopic) {
            recordConsumer.accept(new ApiMessageAndVersion((ApiMessage)MirrorTopic.toSnapshotRecord(newMirrorTopic, topic), recordVersion));
        } else {
            recordConsumer.accept(new ApiMessageAndVersion((ApiMessage)MirrorTopic.toChangeRecord(newMirrorTopic), recordVersion));
        }
        return ApiError.NONE;
    }

    private boolean isAllowedStateChange(MirrorTopic.State currentState, MirrorTopic.State proposedState) {
        if (currentState == proposedState) {
            return true;
        }
        switch (currentState) {
            case MIRROR: {
                return proposedState == MirrorTopic.State.PAUSED || proposedState == MirrorTopic.State.PENDING_STOPPED || proposedState == MirrorTopic.State.PENDING_SYNCHRONIZE || proposedState == MirrorTopic.State.FAILED;
            }
            case PAUSED: {
                return proposedState == MirrorTopic.State.MIRROR || proposedState == MirrorTopic.State.PENDING_REPAIR || proposedState == MirrorTopic.State.PENDING_STOPPED || proposedState == MirrorTopic.State.PENDING_SYNCHRONIZE || proposedState == MirrorTopic.State.FAILED;
            }
            case FAILED: {
                return proposedState == MirrorTopic.State.PAUSED || proposedState == MirrorTopic.State.PENDING_REPAIR || proposedState == MirrorTopic.State.PENDING_STOPPED;
            }
            case PENDING_STOPPED: {
                return proposedState == MirrorTopic.State.STOPPED || proposedState == MirrorTopic.State.MIRROR;
            }
            case STOPPED: {
                return proposedState == MirrorTopic.State.PENDING_MIRROR;
            }
            case PENDING_MIRROR: {
                return proposedState == MirrorTopic.State.MIRROR || proposedState == MirrorTopic.State.PENDING_STOPPED || proposedState == MirrorTopic.State.PAUSED || proposedState == MirrorTopic.State.FAILED;
            }
            case PENDING_REPAIR: {
                return proposedState == MirrorTopic.State.MIRROR || proposedState == MirrorTopic.State.PAUSED || proposedState == MirrorTopic.State.PENDING_STOPPED || proposedState == MirrorTopic.State.FAILED;
            }
            case PENDING_SYNCHRONIZE: {
                return proposedState == MirrorTopic.State.PENDING_STOPPED || proposedState == MirrorTopic.State.PAUSED || proposedState == MirrorTopic.State.FAILED || proposedState == MirrorTopic.State.MIRROR;
            }
        }
        this.log.error("Unhandled current mirror topic state '" + (Object)((Object)currentState) + "'");
        return false;
    }

    ApiError maybeAddMirrorTopicRecord(CreateTopicsRequestData.CreatableTopic topic, Uuid topicId, Consumer<ApiMessageAndVersion> recordConsumer) {
        if (topic.linkName() == null && topic.mirrorTopic() == null) {
            return ApiError.NONE;
        }
        if (topic.linkName() == null || topic.mirrorTopic() == null) {
            return new ApiError(Errors.INVALID_REQUEST, "Link name and mirror topic name must be provided together");
        }
        try {
            ClusterLinkUtils.validateLinkNameOrThrow((String)topic.linkName());
        }
        catch (Throwable t) {
            return ApiError.fromThrowable((Throwable)t);
        }
        Optional<Uuid> linkId = this.clusterLinkIdResolver.apply(topic.linkName());
        if (!linkId.isPresent()) {
            return new ApiError(Errors.CLUSTER_LINK_NOT_FOUND, "Cluster link " + topic.linkName() + " was not found.");
        }
        short recordVersion = (short)(this.featureControl.metadataVersion().isClusterLinkingFailbackSupported() ? 1 : 0);
        recordConsumer.accept(new ApiMessageAndVersion((ApiMessage)new MirrorTopicRecord().setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setTopicName(topic.name()).setTopicId(topicId).setClusterLinkId(linkId.get()).setClusterLinkName(topic.linkName()).setMirrorStartOffsets(topic.mirrorStartOffsets()).setSourceTopicId(topic.sourceTopicId()).setTimeMs(this.time.milliseconds()).setSourceTopicName(topic.mirrorTopic()), recordVersion));
        return ApiError.NONE;
    }

    void failMirrorTopic(Uuid mirrorTopicId, short errorCode, Consumer<ApiMessageAndVersion> recordConsumer) {
        MirrorTopic mirrorTopic = (MirrorTopic)this.mirrorTopics.get((Object)mirrorTopicId);
        if (mirrorTopic == null) {
            this.log.error("Could not fail mirror topic {} since it does not exist", (Object)mirrorTopicId);
        } else if (mirrorTopic.mirrorState() == MirrorTopic.State.MIRROR || mirrorTopic.mirrorState() == MirrorTopic.State.PENDING_SYNCHRONIZE) {
            MirrorTopic failed = MirrorTopic.failed(mirrorTopic, this.time.milliseconds(), errorCode);
            short recordVersion = (short)(this.featureControl.metadataVersion().isClusterLinkingFailbackSupported() ? 1 : 0);
            recordConsumer.accept(new ApiMessageAndVersion((ApiMessage)MirrorTopic.toChangeRecord(failed), recordVersion));
        } else {
            this.log.info("Not failing mirror topic {} since it is not currently active", (Object)mirrorTopicId);
        }
    }

    void unLinkMirrorTopics(Uuid deletedLinkId, String deletedLinkName) {
        Set mirrorTopicIds = (Set)this.linksToMirrorTopics.remove((Object)deletedLinkId);
        if (mirrorTopicIds != null) {
            this.log.info("Removing mirror topic metadata for {} topics due to deleted cluster link {} with ID {}.", new Object[]{mirrorTopicIds.size(), deletedLinkName, deletedLinkId});
            mirrorTopicIds.forEach(arg_0 -> this.mirrorTopics.remove(arg_0));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Removed mirror topic metadata for topic IDs {}.", (Object)mirrorTopicIds);
            }
        }
    }

    void deleteMirrorTopic(Uuid topicIdToRemove, String topicName) {
        MirrorTopic mirrorTopic = (MirrorTopic)this.mirrorTopics.remove((Object)topicIdToRemove);
        if (mirrorTopic != null) {
            this.log.info("Removing mirror state from topic {} with ID {}", (Object)topicName, (Object)topicIdToRemove);
            Set mirrorTopicsUsingLink = (Set)this.linksToMirrorTopics.get((Object)mirrorTopic.linkId());
            if (mirrorTopicsUsingLink != null) {
                mirrorTopicsUsingLink.remove(topicIdToRemove);
            }
        }
    }

    public void replay(MirrorTopicRecord record) {
        ((TimelineHashSet)this.linksToMirrorTopics.computeIfAbsent((Object)record.clusterLinkId(), __ -> new TimelineHashSet(this.snapshotRegistry, 0))).add((Object)record.topicId());
        this.mirrorTopics.put((Object)record.topicId(), (Object)MirrorTopic.fromRecord(record));
        this.log.info("Created mirror topic {} with topic ID {}, link name {}, and link ID {}.", new Object[]{record.topicName(), record.topicId(), record.clusterLinkName(), record.clusterLinkId()});
    }

    public void replay(MirrorTopicChangeRecord record) {
        MirrorTopic newMirrorTopic;
        MirrorTopic.State state = MirrorTopic.State.fromStateName(record.mirrorTopicState());
        MirrorTopic currentMirrorTopic = (MirrorTopic)this.mirrorTopics.get((Object)record.topicId());
        if (currentMirrorTopic == null) {
            throw new IllegalStateException("Attempting to update unknown mirror topic " + record.topicId());
        }
        switch (state) {
            case MIRROR: {
                newMirrorTopic = MirrorTopic.mirror(currentMirrorTopic, record.timeMs(), record.mirrorStartOffsets());
                break;
            }
            case PAUSED: {
                MirrorTopic.State pendingSynchronizeNextState = record.nextState() == null ? null : MirrorTopic.State.fromStateName(record.nextState());
                newMirrorTopic = MirrorTopic.paused(currentMirrorTopic, record.timeMs(), record.topicLevelPause(), record.linkLevelPause(), MirrorTopic.State.fromStateName(record.previousToPausedState()), record.mirrorStartOffsets(), record.mirrorTopicError(), pendingSynchronizeNextState);
                break;
            }
            case FAILED: {
                newMirrorTopic = MirrorTopic.failed(currentMirrorTopic, record.timeMs(), record.mirrorTopicError());
                break;
            }
            case PENDING_STOPPED: {
                newMirrorTopic = MirrorTopic.pendingStopped(currentMirrorTopic, record.timeMs(), record.promoted());
                break;
            }
            case PENDING_MIRROR: {
                MirrorTopic.State nextState = record.nextState() == null ? null : MirrorTopic.State.fromStateName(record.nextState());
                newMirrorTopic = MirrorTopic.pendingMirror(currentMirrorTopic, record.timeMs(), nextState, record.sourceTopicId());
                break;
            }
            case PENDING_SYNCHRONIZE: {
                MirrorTopic.State nextMirrorState = record.nextState() == null ? null : MirrorTopic.State.fromStateName(record.nextState());
                newMirrorTopic = MirrorTopic.pendingSynchronize(currentMirrorTopic, record.timeMs(), nextMirrorState);
                break;
            }
            case STOPPED: {
                newMirrorTopic = MirrorTopic.stopped(currentMirrorTopic, record.timeMs(), record.stoppedLogEndOffsets());
                break;
            }
            case PENDING_REPAIR: {
                newMirrorTopic = MirrorTopic.pendingRepairMirror(currentMirrorTopic, record.timeMs(), record.mirrorTopicError());
                break;
            }
            default: {
                throw new RuntimeException("Cannot update mirror topic state for topic ID " + record.topicId() + ", unknown mirror state " + record.mirrorTopicState());
            }
        }
        this.log.info("Updating mirror topic {} from {} to {}", new Object[]{newMirrorTopic.topicId(), currentMirrorTopic.mirrorState(), state});
        this.mirrorTopics.put((Object)record.topicId(), (Object)newMirrorTopic);
    }
}

