/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.Optional;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.server.common.MetadataVersion;

public class TopicTypeDetermination {
    public static TopicType forTopicCreation(ControllerRequestContext context, MetadataVersion metadataVersion, boolean partitionGroupsEnabledInConfig) {
        if (partitionGroupsEnabledInConfig && metadataVersion.isPartitionGroupSupported() && TopicTypeDetermination.isMultitenantPrincipal(context) && !TopicTypeDetermination.isHealthcheckTenant(context)) {
            return TopicType.K2;
        }
        return TopicType.STANDARD;
    }

    private static boolean isMultitenantPrincipal(ControllerRequestContext context) {
        return TopicTypeDetermination.multiTenantPrincipalFor(context).isPresent();
    }

    private static boolean isHealthcheckTenant(ControllerRequestContext context) {
        Optional<MultiTenantPrincipal> multiTenantPrincipal = TopicTypeDetermination.multiTenantPrincipalFor(context);
        return multiTenantPrincipal.isPresent() && multiTenantPrincipal.get().tenantMetadata().isHealthcheckTenant;
    }

    private static Optional<MultiTenantPrincipal> multiTenantPrincipalFor(ControllerRequestContext context) {
        KafkaPrincipal kafkaPrincipal = context.principal();
        if (kafkaPrincipal instanceof MultiTenantPrincipal) {
            return Optional.of((MultiTenantPrincipal)kafkaPrincipal);
        }
        return Optional.empty();
    }
}

