/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import org.apache.kafka.controller.metrics.CellControllerMetrics;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.server.fault.FaultHandler;

public class CellMetadataMetricsPublisher
implements MetadataPublisher {
    private final CellControllerMetrics metrics;
    private final FaultHandler faultHandler;
    private MetadataImage prevImage = MetadataImage.EMPTY;

    public CellMetadataMetricsPublisher(CellControllerMetrics metrics, FaultHandler faultHandler) {
        this.metrics = metrics;
        this.faultHandler = faultHandler;
    }

    @Override
    public String name() {
        return "CellMetadataMetricsPublisher";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        switch (manifest.type()) {
            case LOG_DELTA: {
                try {
                    this.publishDelta(newImage, delta);
                    break;
                }
                catch (Throwable e) {
                    this.faultHandler.handleFault("Failed to publish cell metrics from log delta  ending at offset " + manifest.provenance().lastContainedOffset(), e);
                    break;
                }
                finally {
                    this.prevImage = newImage;
                }
            }
            case SNAPSHOT: {
                try {
                    this.publishSnapshot(newImage);
                    break;
                }
                catch (Throwable e) {
                    this.faultHandler.handleFault("Failed to publish cell metrics from " + manifest.provenance().snapshotName(), e);
                    break;
                }
                finally {
                    this.prevImage = newImage;
                }
            }
        }
    }

    private void publishDelta(MetadataImage newImage, MetadataDelta delta) {
        if (delta.getOrCreateCellDelta() != null && !this.prevImage.cells().equals(newImage.cells())) {
            this.metrics.updateCellMigrationState(newImage.cells().cellMigrationState());
        }
    }

    private void publishSnapshot(MetadataImage newImage) {
        byte cellMigrationState = newImage.cells().cellMigrationState();
        this.metrics.updateCellMigrationState(cellMigrationState);
    }

    @Override
    public void close() {
        this.metrics.close();
    }
}

