/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.server.util.BrokerReplicaExclusionUtils;

public class BrokerReplicaExclusionsDelta {
    private final BrokerReplicaExclusionsImage originalImage;
    private Map<Integer, String> latestExclusions;
    private Set<Integer> newExclusions;
    private Set<Integer> removedExclusions;

    public BrokerReplicaExclusionsDelta(BrokerReplicaExclusionsImage image) {
        this.originalImage = image;
        this.latestExclusions = new HashMap<Integer, String>(image.activeBrokerReplicaExclusions());
        this.newExclusions = Collections.emptySet();
        this.removedExclusions = Collections.emptySet();
    }

    public void replay(BrokerReplicaExclusionRecord exclusionRecord) {
        this.latestExclusions = exclusionRecord.brokerExclusions().stream().collect(Collectors.toMap(BrokerReplicaExclusionRecord.BrokerReplicaExclusion::brokerId, BrokerReplicaExclusionRecord.BrokerReplicaExclusion::reason));
        this.newExclusions = exclusionRecord.brokerExclusions().stream().filter(exclusion -> !BrokerReplicaExclusionUtils.exclusionExists(this.originalImage.activeBrokerReplicaExclusions(), (int)exclusion.brokerId(), (String)exclusion.reason())).map(BrokerReplicaExclusionRecord.BrokerReplicaExclusion::brokerId).collect(Collectors.toSet());
        this.removedExclusions = this.originalImage.activeBrokerReplicaExclusions().keySet().stream().filter(brokerId -> !BrokerReplicaExclusionUtils.exclusionExists(this.latestExclusions, (int)brokerId)).collect(Collectors.toSet());
    }

    public BrokerReplicaExclusionsImage apply() {
        return new BrokerReplicaExclusionsImage(this.latestExclusions);
    }

    public Set<Integer> newExclusions() {
        return new HashSet<Integer>(this.newExclusions);
    }

    public Set<Integer> removedExclusions() {
        return new HashSet<Integer>(this.removedExclusions);
    }

    public void finishSnapshot() {
    }

    public String toString() {
        return "BrokerReplicaExclusionsDelta{newExclusions=" + this.newExclusions + ", removedExclusions=" + this.removedExclusions + "}";
    }
}

