/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.CellMigrationRecord;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.DelegationTokenRecord;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveCellRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveDelegationTokenRecord;
import org.apache.kafka.common.metadata.RemoveTenantRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.RemoveUserScramCredentialRecord;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.metadata.ZkMigrationStateRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.AclsDelta;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsDelta;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellDelta;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksDelta;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenDelta;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsDelta;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramDelta;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantDelta;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public final class MetadataDelta {
    private final MetadataImage image;
    private final Function<String, String> nameToTenantCallback;
    private final MetadataEncryptorFactory encryptorFactory;
    private MetadataEncryptor encryptor;
    private FeaturesDelta featuresDelta = null;
    private ClusterDelta clusterDelta = null;
    private TopicsDelta topicsDelta = null;
    private ConfigurationsDelta configsDelta = null;
    private ClientQuotasDelta clientQuotasDelta = null;
    private ProducerIdsDelta producerIdsDelta = null;
    private AclsDelta aclsDelta = null;
    private ClusterLinksDelta clusterLinkDelta = null;
    private BrokerReplicaExclusionsDelta brokerReplicaExclusionsDelta = null;
    private CellDelta cellDelta = null;
    private TenantDelta tenantDelta = null;
    private ScramDelta scramDelta = null;
    private DelegationTokenDelta delegationTokenDelta = null;

    public MetadataDelta(MetadataImage image, Function<String, String> nameToTenantCallback, MetadataEncryptorFactory encryptorFactory) {
        this.image = image;
        this.nameToTenantCallback = nameToTenantCallback;
        this.encryptorFactory = encryptorFactory;
        this.encryptor = image.encryptor();
    }

    public MetadataImage image() {
        return this.image;
    }

    public FeaturesDelta featuresDelta() {
        return this.featuresDelta;
    }

    public FeaturesDelta getOrCreateFeaturesDelta() {
        if (this.featuresDelta == null) {
            this.featuresDelta = new FeaturesDelta(this.image.features());
        }
        return this.featuresDelta;
    }

    public ClusterDelta clusterDelta() {
        return this.clusterDelta;
    }

    public ClusterDelta getOrCreateClusterDelta() {
        if (this.clusterDelta == null) {
            this.clusterDelta = new ClusterDelta(this.image.cluster());
        }
        return this.clusterDelta;
    }

    public TopicsDelta topicsDelta() {
        return this.topicsDelta;
    }

    public TopicsDelta getOrCreateTopicsDelta() {
        if (this.topicsDelta == null) {
            this.topicsDelta = new TopicsDelta(this.image.topics(), this.nameToTenantCallback);
        }
        return this.topicsDelta;
    }

    public ConfigurationsDelta configsDelta() {
        return this.configsDelta;
    }

    public ConfigurationsDelta getOrCreateConfigsDelta() {
        if (this.configsDelta == null) {
            this.configsDelta = new ConfigurationsDelta(this.image.configs());
        }
        return this.configsDelta;
    }

    public ClientQuotasDelta clientQuotasDelta() {
        return this.clientQuotasDelta;
    }

    public ClientQuotasDelta getOrCreateClientQuotasDelta() {
        if (this.clientQuotasDelta == null) {
            this.clientQuotasDelta = new ClientQuotasDelta(this.image.clientQuotas());
        }
        return this.clientQuotasDelta;
    }

    public ProducerIdsDelta producerIdsDelta() {
        return this.producerIdsDelta;
    }

    public ProducerIdsDelta getOrCreateProducerIdsDelta() {
        if (this.producerIdsDelta == null) {
            this.producerIdsDelta = new ProducerIdsDelta(this.image.producerIds());
        }
        return this.producerIdsDelta;
    }

    public AclsDelta aclsDelta() {
        return this.aclsDelta;
    }

    public AclsDelta getOrCreateAclsDelta() {
        if (this.aclsDelta == null) {
            this.aclsDelta = new AclsDelta(this.image.acls());
        }
        return this.aclsDelta;
    }

    public ClusterLinksDelta clusterLinksDelta() {
        return this.clusterLinkDelta;
    }

    public ClusterLinksDelta getOrCreateClusterLinksDelta() {
        if (this.clusterLinkDelta == null) {
            this.clusterLinkDelta = new ClusterLinksDelta(this.image.clusterLinks());
        }
        return this.clusterLinkDelta;
    }

    public BrokerReplicaExclusionsDelta getOrCreateBrokerReplicaExclusionsDelta() {
        if (this.brokerReplicaExclusionsDelta == null) {
            this.brokerReplicaExclusionsDelta = new BrokerReplicaExclusionsDelta(this.image.brokerReplicaExclusions());
        }
        return this.brokerReplicaExclusionsDelta;
    }

    public BrokerReplicaExclusionsDelta brokerReplicaExclusionsDelta() {
        return this.brokerReplicaExclusionsDelta;
    }

    public CellDelta getOrCreateCellDelta() {
        if (this.cellDelta == null) {
            this.cellDelta = new CellDelta(this.image.cells());
        }
        return this.cellDelta;
    }

    public TenantDelta getOrCreateTenantDelta() {
        if (this.tenantDelta == null) {
            this.tenantDelta = new TenantDelta(this.image.tenants());
        }
        return this.tenantDelta;
    }

    public ScramDelta scramDelta() {
        return this.scramDelta;
    }

    public ScramDelta getOrCreateScramDelta() {
        if (this.scramDelta == null) {
            this.scramDelta = new ScramDelta(this.image.scram());
        }
        return this.scramDelta;
    }

    public DelegationTokenDelta delegationTokenDelta() {
        return this.delegationTokenDelta;
    }

    public DelegationTokenDelta getOrCreateDelegationTokenDelta() {
        if (this.delegationTokenDelta == null) {
            this.delegationTokenDelta = new DelegationTokenDelta(this.image.delegationTokens());
        }
        return this.delegationTokenDelta;
    }

    public Optional<MetadataVersion> metadataVersionChanged() {
        if (this.featuresDelta == null) {
            return Optional.empty();
        }
        return this.featuresDelta.metadataVersionChange();
    }

    public void replay(ApiMessage record, short version) {
        MetadataRecordType type = MetadataRecordType.fromId(record.apiKey());
        switch (type) {
            case REGISTER_BROKER_RECORD: {
                this.replay((RegisterBrokerRecord)record);
                break;
            }
            case UNREGISTER_BROKER_RECORD: {
                this.replay((UnregisterBrokerRecord)record);
                break;
            }
            case TOPIC_RECORD: {
                this.replay((TopicRecord)record);
                break;
            }
            case PARTITION_RECORD: {
                this.replay((PartitionRecord)record);
                break;
            }
            case CONFIG_RECORD: {
                this.replay((ConfigRecord)record);
                break;
            }
            case PARTITION_CHANGE_RECORD: {
                this.replay((PartitionChangeRecord)record);
                break;
            }
            case FENCE_BROKER_RECORD: {
                this.replay((FenceBrokerRecord)record);
                break;
            }
            case UNFENCE_BROKER_RECORD: {
                this.replay((UnfenceBrokerRecord)record);
                break;
            }
            case REMOVE_TOPIC_RECORD: {
                this.replay((RemoveTopicRecord)record);
                break;
            }
            case DELEGATION_TOKEN_RECORD: {
                this.replay((DelegationTokenRecord)record);
                break;
            }
            case USER_SCRAM_CREDENTIAL_RECORD: {
                this.replay((UserScramCredentialRecord)record);
                break;
            }
            case FEATURE_LEVEL_RECORD: {
                this.replay((FeatureLevelRecord)record);
                break;
            }
            case CLIENT_QUOTA_RECORD: {
                this.replay((ClientQuotaRecord)record);
                break;
            }
            case PRODUCER_IDS_RECORD: {
                this.replay((ProducerIdsRecord)record);
                break;
            }
            case BROKER_REGISTRATION_CHANGE_RECORD: {
                this.replay((BrokerRegistrationChangeRecord)record);
                break;
            }
            case ACCESS_CONTROL_ENTRY_RECORD: {
                this.replay((AccessControlEntryRecord)record);
                break;
            }
            case REMOVE_ACCESS_CONTROL_ENTRY_RECORD: {
                this.replay((RemoveAccessControlEntryRecord)record);
                break;
            }
            case REMOVE_USER_SCRAM_CREDENTIAL_RECORD: {
                this.replay((RemoveUserScramCredentialRecord)record);
                break;
            }
            case REMOVE_DELEGATION_TOKEN_RECORD: {
                this.replay((RemoveDelegationTokenRecord)record);
                break;
            }
            case NO_OP_RECORD: {
                break;
            }
            case ZK_MIGRATION_STATE_RECORD: {
                this.replay((ZkMigrationStateRecord)record);
                break;
            }
            case REGISTER_CONTROLLER_RECORD: {
                this.replay((RegisterControllerRecord)record);
                break;
            }
            case CLUSTER_LINK_RECORD: {
                this.replay((ClusterLinkRecord)record);
                break;
            }
            case REMOVE_CLUSTER_LINK_RECORD: {
                this.replay((RemoveClusterLinkRecord)record);
                break;
            }
            case MIRROR_TOPIC_RECORD: {
                this.replay((MirrorTopicRecord)record, version);
                break;
            }
            case MIRROR_TOPIC_CHANGE_RECORD: {
                this.replay((MirrorTopicChangeRecord)record, version);
                break;
            }
            case BROKER_REPLICA_EXCLUSION_RECORD: {
                this.replay((BrokerReplicaExclusionRecord)record);
                break;
            }
            case ENCRYPTED_ENVELOPE_RECORD: {
                this.replay((EncryptedEnvelopeRecord)record);
                break;
            }
            case INSTALL_METADATA_ENCRYPTOR_RECORD: {
                this.replay((InstallMetadataEncryptorRecord)record);
                break;
            }
            case CELL_RECORD: {
                this.replay((CellRecord)record);
                break;
            }
            case REMOVE_CELL_RECORD: {
                this.replay((RemoveCellRecord)record);
                break;
            }
            case TENANT_RECORD: {
                this.replay((TenantRecord)record);
                break;
            }
            case REMOVE_TENANT_RECORD: {
                this.replay((RemoveTenantRecord)record);
                break;
            }
            case CELL_MIGRATION_RECORD: {
                this.replay((CellMigrationRecord)record);
                break;
            }
            case TRACE_CONTEXT_RECORD: {
                break;
            }
            case NO_TRACE_CONTEXT_RECORD: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown metadata record type " + (Object)((Object)type));
            }
        }
    }

    public void replay(RegisterBrokerRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(UnregisterBrokerRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(TopicRecord record) {
        this.getOrCreateTopicsDelta().replay(record);
    }

    public void replay(PartitionRecord record) {
        this.getOrCreateTopicsDelta().replay(record);
    }

    public void replay(ConfigRecord record) {
        this.getOrCreateConfigsDelta().replay(record);
    }

    public void replay(PartitionChangeRecord record) {
        this.getOrCreateTopicsDelta().replay(record);
    }

    public void replay(FenceBrokerRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(UnfenceBrokerRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(RemoveTopicRecord record) {
        String topicName = this.getOrCreateTopicsDelta().replay(record);
        this.getOrCreateConfigsDelta().replay(record, topicName);
    }

    public void replay(DelegationTokenRecord record) {
        this.getOrCreateDelegationTokenDelta().replay(record);
    }

    public void replay(RemoveDelegationTokenRecord record) {
        this.getOrCreateDelegationTokenDelta().replay(record);
    }

    public void replay(UserScramCredentialRecord record) {
        this.getOrCreateScramDelta().replay(record);
    }

    public void replay(FeatureLevelRecord record) {
        this.getOrCreateFeaturesDelta().replay(record);
        this.featuresDelta.metadataVersionChange().ifPresent(changedMetadataVersion -> {
            this.getOrCreateClusterDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateConfigsDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateTopicsDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateClientQuotasDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateProducerIdsDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateAclsDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateScramDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
            this.getOrCreateDelegationTokenDelta().handleMetadataVersionChange((MetadataVersion)changedMetadataVersion);
        });
    }

    public void replay(BrokerRegistrationChangeRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void replay(ClientQuotaRecord record) {
        this.getOrCreateClientQuotasDelta().replay(record);
    }

    public void replay(ProducerIdsRecord record) {
        this.getOrCreateProducerIdsDelta().replay(record);
    }

    public void replay(AccessControlEntryRecord record) {
        this.getOrCreateAclsDelta().replay(record);
    }

    public void replay(RemoveAccessControlEntryRecord record) {
        this.getOrCreateAclsDelta().replay(record);
    }

    public void replay(ClusterLinkRecord record) {
        this.getOrCreateClusterLinksDelta().replay(record);
    }

    public void replay(RemoveClusterLinkRecord record) {
        if (this.clusterLinkDelta == null) {
            this.clusterLinkDelta = new ClusterLinksDelta(this.image.clusterLinks());
        }
        this.clusterLinkDelta.replay(record);
        if (this.configsDelta == null) {
            this.configsDelta = new ConfigurationsDelta(this.image.configs());
        }
        this.configsDelta.replay(record);
        if (this.topicsDelta == null) {
            this.topicsDelta = new TopicsDelta(this.image.topics(), this.nameToTenantCallback);
        }
        this.topicsDelta.replay(record);
        this.getOrCreateAclsDelta().replay(record);
    }

    public void replay(MirrorTopicRecord record, short version) {
        this.getOrCreateTopicsDelta().replay(record, version);
    }

    public void replay(MirrorTopicChangeRecord record, short version) {
        this.getOrCreateTopicsDelta().replay(record, version);
    }

    public void replay(BrokerReplicaExclusionRecord record) {
        this.getOrCreateBrokerReplicaExclusionsDelta().replay(record);
    }

    public void replay(EncryptedEnvelopeRecord record) {
        ApiMessageAndVersion inner = this.encryptor.decrypt(record);
        ApiMessage decryptedRecord = inner.message();
        if (decryptedRecord instanceof EncryptedEnvelopeRecord) {
            throw new RuntimeException("Nested encrypted envelope records are not supported.");
        }
        this.replay(decryptedRecord, inner.version());
    }

    public void replay(InstallMetadataEncryptorRecord record) {
        this.encryptor = this.encryptorFactory.createFromConfig(record.keyId());
    }

    public void replay(CellRecord record) {
        this.getOrCreateCellDelta().replay(record);
    }

    public void replay(RemoveCellRecord record) {
        this.getOrCreateCellDelta().replay(record);
    }

    public void replay(TenantRecord record) {
        this.getOrCreateTenantDelta().replay(record);
    }

    public void replay(RemoveTenantRecord record) {
        this.getOrCreateTenantDelta().replay(record);
    }

    public void replay(CellMigrationRecord record) {
        this.getOrCreateCellDelta().replay(record);
    }

    public void replay(RemoveUserScramCredentialRecord record) {
        this.getOrCreateScramDelta().replay(record);
    }

    public void replay(ZkMigrationStateRecord record) {
        this.getOrCreateFeaturesDelta().replay(record);
    }

    public void replay(RegisterControllerRecord record) {
        this.getOrCreateClusterDelta().replay(record);
    }

    public void finishSnapshot() {
        this.getOrCreateFeaturesDelta().finishSnapshot();
        this.getOrCreateClusterDelta().finishSnapshot();
        this.getOrCreateTopicsDelta().finishSnapshot();
        this.getOrCreateConfigsDelta().finishSnapshot();
        this.getOrCreateClientQuotasDelta().finishSnapshot();
        this.getOrCreateProducerIdsDelta().finishSnapshot();
        this.getOrCreateAclsDelta().finishSnapshot();
        this.getOrCreateClusterLinksDelta().finishSnapshot();
        this.getOrCreateBrokerReplicaExclusionsDelta().finishSnapshot();
        this.getOrCreateCellDelta().finishSnapshot();
        this.getOrCreateTenantDelta().finishSnapshot();
        this.getOrCreateScramDelta().finishSnapshot();
        this.getOrCreateDelegationTokenDelta().finishSnapshot();
    }

    public MetadataImage apply(MetadataProvenance provenance) {
        FeaturesImage newFeatures = this.featuresDelta == null ? this.image.features() : this.featuresDelta.apply();
        ClusterImage newCluster = this.clusterDelta == null ? this.image.cluster() : this.clusterDelta.apply();
        TopicsImage newTopics = this.topicsDelta == null ? this.image.topics() : this.topicsDelta.apply();
        ConfigurationsImage newConfigs = this.configsDelta == null ? this.image.configs() : this.configsDelta.apply();
        ClientQuotasImage newClientQuotas = this.clientQuotasDelta == null ? this.image.clientQuotas() : this.clientQuotasDelta.apply();
        ProducerIdsImage newProducerIds = this.producerIdsDelta == null ? this.image.producerIds() : this.producerIdsDelta.apply();
        AclsImage newAcls = this.aclsDelta == null ? this.image.acls() : this.aclsDelta.apply();
        ClusterLinksImage newClusterLinksImage = this.clusterLinkDelta == null ? this.image.clusterLinks() : this.clusterLinkDelta.apply();
        BrokerReplicaExclusionsImage newReplicaExclusionsImage = this.brokerReplicaExclusionsDelta == null ? this.image.brokerReplicaExclusions() : this.brokerReplicaExclusionsDelta.apply();
        CellImage newCellImage = this.cellDelta == null ? this.image.cells() : this.cellDelta.apply();
        TenantImage newTenantImage = this.tenantDelta == null ? this.image.tenants() : this.tenantDelta.apply();
        ScramImage newScram = this.scramDelta == null ? this.image.scram() : this.scramDelta.apply();
        DelegationTokenImage newDelegationTokens = this.delegationTokenDelta == null ? this.image.delegationTokens() : this.delegationTokenDelta.apply();
        return new MetadataImage(provenance, newFeatures, newCluster, newTopics, newConfigs, newClientQuotas, newProducerIds, newAcls, newClusterLinksImage, newReplicaExclusionsImage, newCellImage, newTenantImage, newScram, newDelegationTokens, this.encryptor);
    }

    public String toString() {
        return "MetadataDelta(featuresDelta=" + this.featuresDelta + ", clusterDelta=" + this.clusterDelta + ", topicsDelta=" + this.topicsDelta + ", configsDelta=" + this.configsDelta + ", clientQuotasDelta=" + this.clientQuotasDelta + ", producerIdsDelta=" + this.producerIdsDelta + ", aclsDelta=" + this.aclsDelta + ", clusterLinkDelta=" + this.clusterLinkDelta + ", brokerReplicaExclusionsDelta=" + this.brokerReplicaExclusionsDelta + ", encryptorId=" + this.encryptor.id() + ", cellDelta=" + this.cellDelta + ", tenantDelta=" + this.tenantDelta + ", scramDelta=" + this.scramDelta + ", delegationTokenDelta=" + this.delegationTokenDelta + ')';
    }

    public static class Builder {
        private MetadataImage image = MetadataImage.EMPTY;
        private Function<String, String> nameToTenantCallback = __ -> null;
        private MetadataEncryptorFactory encryptorFactory = null;

        public Builder setImage(MetadataImage image) {
            this.image = image;
            return this;
        }

        public Builder setNameToTenantCallback(Function<String, String> nameToTenantCallback) {
            this.nameToTenantCallback = nameToTenantCallback;
            return this;
        }

        public Builder setMetadataEncryptorFactory(MetadataEncryptorFactory encryptorFactory) {
            this.encryptorFactory = encryptorFactory;
            return this;
        }

        public MetadataDelta build() {
            if (this.encryptorFactory == null) {
                this.encryptorFactory = new MetadataEncryptorFactory();
            }
            return new MetadataDelta(this.image, this.nameToTenantCallback, this.encryptorFactory);
        }
    }
}

