/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher;

import java.util.Optional;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.image.publisher.metrics.SnapshotEmitterMetrics;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RaftSnapshotWriter;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.slf4j.Logger;

public class SnapshotEmitter
implements SnapshotGenerator.Emitter {
    private static final int DEFAULT_BATCH_SIZE = 1024;
    private final Logger log;
    private final Time time;
    private final RaftClient<ApiMessageAndVersion> raftClient;
    private final int batchSize;
    private final SnapshotEmitterMetrics metrics;
    private final KafkaConfigSchema configSchema;

    private SnapshotEmitter(Time time, int nodeId, RaftClient<ApiMessageAndVersion> raftClient, int batchSize, SnapshotEmitterMetrics metrics, KafkaConfigSchema configSchema) {
        this.time = time;
        this.log = new LogContext("[SnapshotEmitter id=" + nodeId + "] ").logger(SnapshotEmitter.class);
        this.raftClient = raftClient;
        this.batchSize = batchSize;
        this.metrics = metrics;
        this.configSchema = configSchema;
    }

    public SnapshotEmitterMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void maybeEmit(MetadataImage image) {
        MetadataProvenance provenance = image.provenance();
        Optional snapshotWriter = this.raftClient.createSnapshot(provenance.snapshotId(), provenance.lastContainedLogTimeMs());
        if (!snapshotWriter.isPresent()) {
            this.log.error("Not generating {} because it already exists.", (Object)provenance.snapshotName());
            return;
        }
        RaftSnapshotWriter writer = new RaftSnapshotWriter((SnapshotWriter<ApiMessageAndVersion>)((SnapshotWriter)snapshotWriter.get()), this.batchSize);
        try {
            image.write(writer, new ImageWriterOptions.Builder().setMetadataVersion(image.features().metadataVersion()).setConfigSchema(this.configSchema).build());
            writer.close(true);
            this.metrics.setLatestSnapshotGeneratedTimeMs(this.time.milliseconds());
            this.metrics.setLatestSnapshotGeneratedBytes(writer.frozenSize().getAsLong());
            this.log.info("Successfully wrote {}", (Object)provenance.snapshotName());
        }
        catch (Throwable e) {
            this.log.error("Encountered error while writing {}", (Object)provenance.snapshotName(), (Object)e);
            throw e;
        }
        finally {
            Utils.closeQuietly((AutoCloseable)writer, (String)"RaftSnapshotWriter");
            Utils.closeQuietly((AutoCloseable)((AutoCloseable)snapshotWriter.get()), (String)"SnapshotWriter");
        }
    }

    public static class Builder {
        private Time time = Time.SYSTEM;
        private int nodeId = 0;
        private RaftClient<ApiMessageAndVersion> raftClient = null;
        private int batchSize = 1024;
        private SnapshotEmitterMetrics metrics = null;
        private KafkaConfigSchema configSchema = KafkaConfigSchema.EMPTY;

        public Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        public Builder setNodeId(int nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setRaftClient(RaftClient<ApiMessageAndVersion> raftClient) {
            this.raftClient = raftClient;
            return this;
        }

        public Builder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder setMetrics(SnapshotEmitterMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder setConfigSchema(KafkaConfigSchema configSchema) {
            this.configSchema = configSchema;
            return this;
        }

        public SnapshotEmitter build() {
            if (this.raftClient == null) {
                throw new RuntimeException("You must set the raftClient.");
            }
            if (this.metrics == null) {
                this.metrics = new SnapshotEmitterMetrics(Optional.empty(), this.time);
            }
            return new SnapshotEmitter(this.time, this.nodeId, this.raftClient, this.batchSize, this.metrics, this.configSchema);
        }
    }
}

