/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum BrokerState {
    NOT_RUNNING(0),
    STARTING(1),
    RECOVERY(2),
    RUNNING(3),
    PENDING_CONTROLLED_SHUTDOWN(6),
    SHUTTING_DOWN(7),
    UNKNOWN(127);

    private static final Map<Byte, BrokerState> VALUES_TO_ENUMS;
    private final byte value;

    private BrokerState(byte value) {
        this.value = value;
    }

    public static BrokerState fromValue(byte value) {
        BrokerState state = VALUES_TO_ENUMS.get(value);
        if (state == null) {
            return UNKNOWN;
        }
        return state;
    }

    public byte value() {
        return this.value;
    }

    public boolean isShutdownInitiated() {
        return this == PENDING_CONTROLLED_SHUTDOWN || this == SHUTTING_DOWN;
    }

    static {
        VALUES_TO_ENUMS = new HashMap<Byte, BrokerState>();
        for (BrokerState state : BrokerState.values()) {
            VALUES_TO_ENUMS.put(state.value(), state);
        }
    }
}

