/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.authorizer.AclsBuilder;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.PrefixNode;
import org.apache.kafka.metadata.authorizer.PrefixTreeBuilder;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.ResourceAclsBuilder;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerData;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.immutable.ImmutableNavigableMap;
import org.apache.kafka.server.immutable.ImmutableSet;

class AclLoader {
    private ImmutableMap<Uuid, ConfluentStandardAcl> aclsById;
    private ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> activeAclsByResourceType;
    private ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> inactiveAclsByResourceType;
    private final ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> prefixed;
    private final ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> literals;
    private final Map<ResourceType, Map<KafkaPrincipal, PrefixTreeBuilder>> prefixChanges;
    private final Map<KafkaPrincipal, Map<Resource, ResourceAclsBuilder>> literalChanges;

    AclLoader(Map<Uuid, ConfluentStandardAcl> snapshot) {
        this.aclsById = ImmutableMap.empty();
        this.activeAclsByResourceType = ImmutableMap.empty();
        this.inactiveAclsByResourceType = ImmutableMap.empty();
        this.prefixed = ImmutableMap.empty();
        this.literals = ImmutableMap.empty();
        this.literalChanges = new HashMap<KafkaPrincipal, Map<Resource, ResourceAclsBuilder>>();
        this.prefixChanges = new HashMap<ResourceType, Map<KafkaPrincipal, PrefixTreeBuilder>>();
        for (Map.Entry<Uuid, ConfluentStandardAcl> entry : snapshot.entrySet()) {
            this.handleAddAcl(entry.getKey(), entry.getValue());
        }
    }

    AclLoader(ImmutableMap<Uuid, ConfluentStandardAcl> aclsById, ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> aclsByResourceType, ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> inactiveAclsByResourceType, ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> prefixed, ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> literals, Map<Uuid, Optional<ConfluentStandardAcl>> changes) {
        this.aclsById = aclsById;
        this.activeAclsByResourceType = aclsByResourceType;
        this.inactiveAclsByResourceType = inactiveAclsByResourceType;
        this.prefixed = prefixed;
        this.literals = literals;
        this.prefixChanges = new HashMap<ResourceType, Map<KafkaPrincipal, PrefixTreeBuilder>>(0);
        this.literalChanges = new HashMap<KafkaPrincipal, Map<Resource, ResourceAclsBuilder>>(0);
        for (Map.Entry<Uuid, Optional<ConfluentStandardAcl>> entry : changes.entrySet()) {
            if (entry.getValue().isPresent()) {
                this.handleAddAcl(entry.getKey(), entry.getValue().get());
                continue;
            }
            this.handleRemoveAcl(entry.getKey());
        }
    }

    private void handleAddAcl(Uuid id, ConfluentStandardAcl newAcl) {
        ConfluentStandardAcl oldAcl = (ConfluentStandardAcl)this.aclsById.get((Object)id);
        if (oldAcl != null) {
            if (oldAcl.equals(newAcl)) {
                throw new RuntimeException("An ACL with ID " + id + " already exists.");
            }
            this.handleRemoveAcl(id);
        }
        this.aclsById = this.aclsById.updated((Object)id, (Object)newAcl);
        Optional<Uuid> linkIdToAdd = newAcl.clusterLinkId();
        StandardAcl newStandardAcl = newAcl.standardAcl();
        StandardAuthorizerData.ResourceTypeKey key = new StandardAuthorizerData.ResourceTypeKey(newStandardAcl.resourceType(), newStandardAcl.kafkaPrincipal(), newStandardAcl.host(), newStandardAcl.operation());
        boolean isActive = newAcl.aclState() == AclState.ACTIVE;
        Object aclsByResource = isActive ? this.activeAclsByResourceType : this.inactiveAclsByResourceType;
        ImmutableNavigableMap aclsForResourcePattern = (ImmutableNavigableMap)aclsByResource.getOrDefault((Object)key, (Object)ImmutableNavigableMap.empty());
        StandardAuthorizerData.AclLinks aclLinks = (StandardAuthorizerData.AclLinks)aclsForResourcePattern.get((Object)newStandardAcl);
        if (aclLinks == null) {
            aclLinks = new StandardAuthorizerData.AclLinks(newStandardAcl, (ImmutableSet<Uuid>)ImmutableSet.singleton((Object)linkIdToAdd.orElse(Uuid.ZERO_UUID)));
            if (isActive) {
                this.getOrCreateChangeObject(newStandardAcl).newAddition(newStandardAcl);
            }
        } else {
            aclLinks = aclLinks.copyAndAddLinkId(linkIdToAdd);
        }
        aclsForResourcePattern = aclsForResourcePattern.updated((Object)newStandardAcl, (Object)aclLinks);
        aclsByResource = aclsByResource.updated((Object)key, (Object)aclsForResourcePattern);
        if (isActive) {
            this.activeAclsByResourceType = aclsByResource;
        } else {
            this.inactiveAclsByResourceType = aclsByResource;
        }
    }

    private void handleRemoveAcl(Uuid id) {
        ConfluentStandardAcl oldAcl = (ConfluentStandardAcl)this.aclsById.get((Object)id);
        if (oldAcl == null) {
            throw new RuntimeException("ID " + id + " not found in aclsById.");
        }
        this.aclsById = this.aclsById.removed((Object)id);
        StandardAcl oldStandardAcl = oldAcl.standardAcl();
        StandardAuthorizerData.ResourceTypeKey key = new StandardAuthorizerData.ResourceTypeKey(oldStandardAcl.resourceType(), oldStandardAcl.kafkaPrincipal(), oldStandardAcl.host(), oldStandardAcl.operation());
        boolean isActive = oldAcl.aclState() == AclState.ACTIVE;
        ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> aclsByResource = isActive ? this.activeAclsByResourceType : this.inactiveAclsByResourceType;
        ImmutableNavigableMap aclsForResourcePattern = (ImmutableNavigableMap)aclsByResource.getOrDefault((Object)key, (Object)ImmutableNavigableMap.empty());
        StandardAuthorizerData.AclLinks links = (StandardAuthorizerData.AclLinks)aclsForResourcePattern.get((Object)oldStandardAcl);
        if (links == null) {
            throw new RuntimeException("ACL  " + oldAcl + " not found in aclsByResource");
        }
        StandardAuthorizerData.AclLinks newAclLinks = links.copyAndRemoveLinkId(oldAcl.clusterLinkId());
        if (newAclLinks.isEmpty()) {
            aclsForResourcePattern = aclsForResourcePattern.removed((Object)oldStandardAcl);
            if (isActive) {
                this.getOrCreateChangeObject(oldStandardAcl).newRemoval(oldStandardAcl);
            }
        } else {
            aclsForResourcePattern = aclsForResourcePattern.updated((Object)oldStandardAcl, (Object)newAclLinks);
        }
        if (aclsForResourcePattern.isEmpty()) {
            if (isActive) {
                this.activeAclsByResourceType = this.activeAclsByResourceType.removed((Object)key);
            } else {
                this.inactiveAclsByResourceType = this.inactiveAclsByResourceType.removed((Object)key);
            }
        } else if (isActive) {
            this.activeAclsByResourceType = this.activeAclsByResourceType.updated((Object)key, (Object)aclsForResourcePattern);
        } else {
            this.inactiveAclsByResourceType = this.inactiveAclsByResourceType.updated((Object)key, (Object)aclsForResourcePattern);
        }
    }

    AclsBuilder<?> getOrCreateChangeObject(StandardAcl acl) {
        if (acl.isWildcardOrPrefix()) {
            return this.prefixChanges.computeIfAbsent(acl.resourceType(), __ -> new HashMap()).computeIfAbsent(acl.kafkaPrincipal(), __ -> new PrefixTreeBuilder());
        }
        if (acl.patternType() == PatternType.LITERAL) {
            return this.literalChanges.computeIfAbsent(acl.kafkaPrincipal(), __ -> new HashMap()).computeIfAbsent(acl.resource(), __ -> new ResourceAclsBuilder());
        }
        throw new RuntimeException("Unsupported patternType " + acl.patternType());
    }

    Result build() {
        ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> newLiterals = AclLoader.buildLiteralMap(this.literals, this.literalChanges);
        ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> newPrefixed = AclLoader.buildPrefixedMap(this.prefixed, this.prefixChanges);
        return new Result(this.aclsById, this.activeAclsByResourceType, this.inactiveAclsByResourceType, newPrefixed, newLiterals);
    }

    static ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> buildLiteralMap(ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> prevMap, Map<KafkaPrincipal, Map<Resource, ResourceAclsBuilder>> changeMap) {
        if (changeMap.isEmpty()) {
            return prevMap;
        }
        ImmutableMap newMap = prevMap;
        for (Map.Entry<KafkaPrincipal, Map<Resource, ResourceAclsBuilder>> entry : changeMap.entrySet()) {
            KafkaPrincipal principal = entry.getKey();
            Map<Resource, ResourceAclsBuilder> changes = entry.getValue();
            ImmutableMap<Resource, ResourceAcls> newResourceLiterals = AclLoader.buildPrincipalLiteralMap((ImmutableMap<Resource, ResourceAcls>)((ImmutableMap)newMap.getOrDefault((Object)principal, (Object)ImmutableMap.empty())), changes);
            if (newResourceLiterals.isEmpty()) {
                newMap = newMap.removed((Object)principal);
                continue;
            }
            newMap = newMap.updated((Object)principal, newResourceLiterals);
        }
        return newMap;
    }

    static ImmutableMap<Resource, ResourceAcls> buildPrincipalLiteralMap(ImmutableMap<Resource, ResourceAcls> prevMap, Map<Resource, ResourceAclsBuilder> changeMap) {
        if (changeMap.isEmpty()) {
            return prevMap;
        }
        ImmutableMap newMap = prevMap;
        for (Map.Entry<Resource, ResourceAclsBuilder> entry : changeMap.entrySet()) {
            Resource resource = entry.getKey();
            ResourceAclsBuilder changes = entry.getValue();
            ResourceAcls resourceAcls = (ResourceAcls)newMap.getOrDefault((Object)resource, (Object)ResourceAcls.EMPTY);
            ResourceAcls newResourceAcls = resourceAcls.copyWithChanges(changes);
            if (newResourceAcls.isEmpty()) {
                newMap = newMap.removed((Object)resource);
                continue;
            }
            newMap = newMap.updated((Object)resource, (Object)newResourceAcls);
        }
        return newMap;
    }

    static ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> buildPrefixedMap(ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> prevPrefixed, Map<ResourceType, Map<KafkaPrincipal, PrefixTreeBuilder>> prefixChanges) {
        if (prefixChanges.isEmpty()) {
            return prevPrefixed;
        }
        ImmutableMap newPrefixed = prevPrefixed;
        for (Map.Entry<ResourceType, Map<KafkaPrincipal, PrefixTreeBuilder>> entry : prefixChanges.entrySet()) {
            ResourceType resourceType = entry.getKey();
            Map<KafkaPrincipal, PrefixTreeBuilder> principalPrefixTreeBuilderMap = entry.getValue();
            ImmutableMap principalPrefixNodeMap = (ImmutableMap)newPrefixed.getOrDefault((Object)resourceType, (Object)ImmutableMap.empty());
            for (Map.Entry<KafkaPrincipal, PrefixTreeBuilder> principalPrefixTreeBuilderEntry : principalPrefixTreeBuilderMap.entrySet()) {
                KafkaPrincipal principal = principalPrefixTreeBuilderEntry.getKey();
                PrefixNode oldPrefixNode = (PrefixNode)principalPrefixNodeMap.getOrDefault((Object)principal, (Object)PrefixNode.EMPTY);
                PrefixNode newPrefixNode = principalPrefixTreeBuilderEntry.getValue().build(oldPrefixNode);
                if (newPrefixNode.isEmpty()) {
                    principalPrefixNodeMap = principalPrefixNodeMap.removed((Object)principal);
                    continue;
                }
                principalPrefixNodeMap = principalPrefixNodeMap.updated((Object)principal, (Object)newPrefixNode);
            }
            if (principalPrefixNodeMap.isEmpty()) {
                newPrefixed = newPrefixed.removed((Object)resourceType);
                continue;
            }
            newPrefixed = newPrefixed.updated((Object)resourceType, (Object)principalPrefixNodeMap);
        }
        return newPrefixed;
    }

    static class Result {
        private final ImmutableMap<Uuid, ConfluentStandardAcl> newAclsById;
        private final ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> newAclsByResource;
        private final ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> newInactiveAclsByResource;
        private final ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> newPrefixed;
        private final ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> newLiterals;

        Result(ImmutableMap<Uuid, ConfluentStandardAcl> newAclsById, ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> newAclsByResource, ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> newInactiveAclsByResource, ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> newPrefixed, ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> newLiterals) {
            this.newAclsById = newAclsById;
            this.newAclsByResource = newAclsByResource;
            this.newInactiveAclsByResource = newInactiveAclsByResource;
            this.newPrefixed = newPrefixed;
            this.newLiterals = newLiterals;
        }

        ImmutableMap<Uuid, ConfluentStandardAcl> newAclsById() {
            return this.newAclsById;
        }

        ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> newAclsByResource() {
            return this.newAclsByResource;
        }

        ImmutableMap<StandardAuthorizerData.ResourceTypeKey, ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>> newInactiveAclsByResource() {
            return this.newInactiveAclsByResource;
        }

        ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> newPrefixed() {
            return this.newPrefixed;
        }

        ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> newLiterals() {
            return this.newLiterals;
        }

        public int hashCode() {
            return Objects.hash(this.newAclsById, this.newPrefixed, this.newLiterals);
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            Result other = (Result)o;
            return this.newAclsById.equals(other.newAclsById) && this.newPrefixed.equals(other.newPrefixed) && this.newLiterals.equals(other.newLiterals);
        }

        public String toString() {
            return "Result(newAclsById=" + this.newAclsById + ", newPrefixed=" + this.newPrefixed + ", newLiterals=" + this.newLiterals + ")";
        }
    }
}

