/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.acl.AclUpdateListener;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.MatchingRule;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerData;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;

public class StandardAuthorizer
implements ClusterMetadataAuthorizer {
    public static final String SUPER_USERS_CONFIG = "super.users";
    public static final String ALLOW_EVERYONE_IF_NO_ACL_IS_FOUND_CONFIG = "allow.everyone.if.no.acl.found";
    private final CompletableFuture<Void> initialLoadFuture = new CompletableFuture();
    private volatile StandardAuthorizerData data;
    private final Set<AclUpdateListener> aclUpdateListeners = new HashSet<AclUpdateListener>();
    private boolean enableAclState = false;

    public StandardAuthorizer() {
        this.data = StandardAuthorizerData.createEmpty();
    }

    @Override
    public void setAclMutator(AclMutator aclMutator) {
        this.data = this.data.copyWithNewAclMutator(aclMutator);
    }

    @Override
    public AclMutator aclMutatorOrException() {
        AclMutator aclMutator = this.data.aclMutator;
        if (aclMutator == null) {
            throw new NotControllerException("The current node is not the active controller.");
        }
        return aclMutator;
    }

    @Override
    public void completeInitialLoad() {
        this.data = this.data.copyWithNewLoadingComplete(true);
        this.data.log.info("Completed initial ACL load process.");
        this.initialLoadFuture.complete(null);
    }

    public CompletableFuture<Void> initialLoadFuture() {
        return this.initialLoadFuture;
    }

    @Override
    public void completeInitialLoad(Exception e) {
        this.data.log.error("Failed to complete initial ACL load process.", (Throwable)e);
        this.initialLoadFuture.completeExceptionally(e);
    }

    @Override
    public synchronized void loadAclSnapshot(Map<Uuid, ConfluentStandardAcl> acls) {
        this.data = this.data.copyWithAclSnapshot(acls);
    }

    @Override
    public synchronized void applyAclChanges(Map<Uuid, Optional<ConfluentStandardAcl>> aclChanges) {
        ArrayList<ConfluentStandardAcl> aclsUpdated = new ArrayList<ConfluentStandardAcl>();
        aclChanges.forEach((id, aclOpt) -> {
            if (aclOpt.isPresent()) {
                aclsUpdated.add((ConfluentStandardAcl)aclOpt.get());
            } else {
                aclsUpdated.add(this.data.getAcl((Uuid)id));
            }
        });
        this.data = this.data.copyWithAclChanges(aclChanges);
        this.notifyListeners(aclsUpdated);
    }

    private void notifyListeners(List<ConfluentStandardAcl> acls) {
        if (this.aclUpdateListeners.isEmpty()) {
            return;
        }
        acls.forEach(acl -> {
            ResourcePattern resourcePattern = acl.standardAcl().resourcePattern();
            HashSet<AccessControlEntry> accessControlEntries = new HashSet<AccessControlEntry>();
            for (AclBinding aclBinding : this.data.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))) {
                accessControlEntries.add(aclBinding.entry());
            }
            this.aclUpdateListeners.forEach(listener -> listener.handleUpdate(resourcePattern, accessControlEntries));
        });
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        HashMap<Endpoint, CompletableFuture<Object>> result = new HashMap<Endpoint, CompletableFuture<Object>>();
        for (Endpoint endpoint : serverInfo.endpoints()) {
            if (serverInfo.earlyStartListeners().contains(endpoint.listenerName().orElse(""))) {
                result.put(endpoint, CompletableFuture.completedFuture(null));
                continue;
            }
            result.put(endpoint, this.initialLoadFuture);
        }
        return result;
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        ArrayList<AuthorizationResult> results = new ArrayList<AuthorizationResult>(actions.size());
        StandardAuthorizerData curData = this.data;
        for (Action action : actions) {
            AuthorizationResult result = curData.authorize(requestContext, action);
            results.add(result);
        }
        return results;
    }

    public MatchingRule findAuthorizationRule(Set<KafkaPrincipal> matchingPrincipals, String host, Action action) {
        return this.data.findAuthorizationRule(matchingPrincipals, host, action);
    }

    public List<StandardAcl> findRulesByResourceType(ResourceType resourceType, AclOperation operation, Set<KafkaPrincipal> matchingPrincipals, String host) {
        return this.data.findRulesByResourceType(matchingPrincipals, host, operation, resourceType);
    }

    public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        return this.data.authorizeByResourceType(requestContext, op, resourceType);
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        return this.acls(filter, AclState.ACTIVE);
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter, AclState aclState) {
        if (!this.isAclStateEnabled() && aclState != AclState.ACTIVE) {
            throw new IllegalArgumentException("Invalid AclState : " + aclState + " when setting AclState is disabled");
        }
        return this.data.acls(filter, aclState);
    }

    public int aclCount() {
        return this.data.aclCount();
    }

    public void close() throws IOException {
        this.initialLoadFuture.completeExceptionally((Throwable)new TimeoutException("The authorizer was closed before the initial load could complete."));
        this.data = StandardAuthorizerData.createEmpty();
        this.aclUpdateListeners.clear();
    }

    public void configure(Map<String, ?> configs) {
        int nodeId;
        Set<String> superUsers = StandardAuthorizer.getConfiguredSuperUsers(configs);
        AuthorizationResult defaultResult = StandardAuthorizer.getDefaultResult(configs);
        if (configs.get("confluent.multitenant.authorizer.enable.acl.state") != null) {
            this.enableAclState = Boolean.parseBoolean(configs.get("confluent.multitenant.authorizer.enable.acl.state").toString().trim());
        }
        try {
            nodeId = Integer.parseInt(configs.get("node.id").toString().trim());
        }
        catch (Exception e) {
            nodeId = -1;
        }
        this.data = this.data.copyWithNewConfig(nodeId, superUsers, defaultResult);
        this.data.log.info("set super.users={}, default result={}", (Object)String.join((CharSequence)",", superUsers), (Object)defaultResult);
    }

    Set<String> superUsers() {
        return new HashSet<String>(this.data.superUsers());
    }

    AuthorizationResult defaultResult() {
        return this.data.defaultResult();
    }

    static Set<String> getConfiguredSuperUsers(Map<String, ?> configs) {
        Object configValue = configs.get(SUPER_USERS_CONFIG);
        if (configValue == null) {
            return Collections.emptySet();
        }
        String[] values = configValue.toString().split(";");
        HashSet<String> result = new HashSet<String>();
        for (String value : values) {
            String v = value.trim();
            if (v.isEmpty()) continue;
            SecurityUtils.parseKafkaPrincipal((String)v);
            result.add(v);
        }
        return result;
    }

    static AuthorizationResult getDefaultResult(Map<String, ?> configs) {
        Object configValue = configs.get(ALLOW_EVERYONE_IF_NO_ACL_IS_FOUND_CONFIG);
        if (configValue == null) {
            return AuthorizationResult.DENIED;
        }
        return Boolean.parseBoolean(configValue.toString().trim()) ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED;
    }

    public boolean validateAclCaches() {
        return this.data.validateAclCaches();
    }

    public void registerAclUpdateListener(AclUpdateListener aclUpdateListener) {
        this.aclUpdateListeners.add(aclUpdateListener);
    }

    public boolean isAclStateEnabled() {
        return this.enableAclState;
    }

    @Override
    public AclCreateResult createInactiveAcls(AuthorizableRequestContext context, AclBindingFilter filter) throws RuntimeException, ExecutionException, InterruptedException {
        ArrayList<AclBinding> bindings = new ArrayList<AclBinding>();
        this.acls(filter).forEach(bindings::add);
        List results = this.createAcls(context, bindings, AclState.DELETED).stream().map(CompletionStage::toCompletableFuture).collect(Collectors.toList());
        for (CompletableFuture result : results) {
            AclCreateResult createResult = (AclCreateResult)result.get();
            if (!createResult.exception().isPresent()) continue;
            return createResult;
        }
        return AclCreateResult.SUCCESS;
    }

    @Override
    public void validateCreateAclState(AclState aclState) {
        if (!this.isAclStateEnabled() && aclState != AclState.ACTIVE) {
            throw new IllegalArgumentException("Invalid AclState : " + aclState + " when setting AclState is disabled");
        }
    }

    @Override
    public void validateDeleteAclState(AclState aclState) {
        if (!this.isAclStateEnabled() && aclState != AclState.ANY) {
            throw new IllegalArgumentException("Invalid AclState : " + aclState + " when setting AclState is disabled");
        }
    }
}

