/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.AstBuilder;
import io.confluent.ksql.parser.GrammarParseUtil;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.util.ParserUtil;

public final class ExpressionParser {
    private ExpressionParser() {
    }

    public static SelectExpression parseSelectExpression(String expressionText) {
        SqlBaseParser.SelectItemContext parseCtx = GrammarParseUtil.getParseTree(expressionText, SqlBaseParser::selectItem);
        if (!(parseCtx instanceof SqlBaseParser.SelectSingleContext)) {
            throw new IllegalArgumentException("Illegal select item type in: " + expressionText);
        }
        SqlBaseParser.SelectSingleContext selectSingleContext = (SqlBaseParser.SelectSingleContext)parseCtx;
        if (selectSingleContext.identifier() == null) {
            throw new IllegalArgumentException("Select item must have identifier in: " + expressionText);
        }
        return SelectExpression.of((ColumnName)ColumnName.of((String)ParserUtil.getIdentifierText(selectSingleContext.identifier())), (Expression)new AstBuilder(TypeRegistry.EMPTY).buildExpression(selectSingleContext.expression()));
    }

    public static Expression parseExpression(String expressionText) {
        SqlBaseParser.SingleExpressionContext parseTree = GrammarParseUtil.getParseTree(expressionText, SqlBaseParser::singleExpression);
        return new AstBuilder(TypeRegistry.EMPTY).buildExpression(parseTree);
    }

    public static KsqlWindowExpression parseWindowExpression(String expressionText) {
        SqlBaseParser.WindowExpressionContext parseTree = GrammarParseUtil.getParseTree(expressionText, SqlBaseParser::windowExpression);
        WindowExpression windowExpression = new AstBuilder(TypeRegistry.EMPTY).buildWindowExpression(parseTree);
        return windowExpression.getKsqlWindowExpression();
    }
}

