/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.confluent.ksql.execution.expression.formatter.ExpressionFormatter;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.AssertTable;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.AlterOption;
import io.confluent.ksql.parser.tree.AlterSource;
import io.confluent.ksql.parser.tree.AlterSystemProperty;
import io.confluent.ksql.parser.tree.AssertStream;
import io.confluent.ksql.parser.tree.AssertTombstone;
import io.confluent.ksql.parser.tree.AssertValues;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.ColumnConstraints;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.DefineVariable;
import io.confluent.ksql.parser.tree.DescribeStreams;
import io.confluent.ksql.parser.tree.DescribeTables;
import io.confluent.ksql.parser.tree.DropStatement;
import io.confluent.ksql.parser.tree.DropStream;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.parser.tree.Explain;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.InsertValues;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinCriteria;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.JoinedSource;
import io.confluent.ksql.parser.tree.ListConnectorPlugins;
import io.confluent.ksql.parser.tree.ListFunctions;
import io.confluent.ksql.parser.tree.ListStreams;
import io.confluent.ksql.parser.tree.ListTables;
import io.confluent.ksql.parser.tree.ListVariables;
import io.confluent.ksql.parser.tree.PartitionBy;
import io.confluent.ksql.parser.tree.PauseQuery;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.RegisterType;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.ResumeQuery;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.ShowColumns;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.StructAll;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TableElements;
import io.confluent.ksql.parser.tree.TerminateQuery;
import io.confluent.ksql.parser.tree.UndefineVariable;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.IdentifierUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class SqlFormatter {
    private static final String INDENT = "   ";
    private static final FormatOptions FORMAT_OPTIONS = FormatOptions.of(IdentifierUtil::needsQuotes);

    private SqlFormatter() {
    }

    public static String formatSql(AstNode root) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder).process(root, 0);
        return StringUtils.stripEnd((String)builder.toString(), (String)"\n");
    }

    private static String formatExpression(Expression expression) {
        return ExpressionFormatter.formatExpression((Expression)expression, (FormatOptions)FormatOptions.of(IdentifierUtil::needsQuotes));
    }

    private static String escapedName(Name<?> name) {
        return name.toString(FORMAT_OPTIONS);
    }

    private static String formatAlterOption(AlterOption option) {
        return "ADD COLUMN " + option.getColumnName() + " " + option.getType();
    }

    private static final class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;

        private Formatter(StringBuilder builder) {
            this.builder = Objects.requireNonNull(builder, "builder");
        }

        @Override
        protected Void visitNode(AstNode node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + (Object)((Object)node));
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            this.process(node.getSelect(), indent);
            this.append(indent, "FROM ");
            this.processRelation(node.getFrom(), indent);
            this.builder.append('\n');
            if (node.getWindow().isPresent()) {
                this.append(indent, "WINDOW" + node.getWindow().get().getKsqlWindowExpression().toString()).append('\n');
            }
            if (node.getWhere().isPresent()) {
                this.append(indent, "WHERE " + SqlFormatter.formatExpression(node.getWhere().get())).append('\n');
            }
            node.getGroupBy().ifPresent(groupBy -> {
                Void cfr_ignored_0 = (Void)this.process((AstNode)((Object)groupBy), indent);
            });
            node.getPartitionBy().ifPresent(partitionBy -> {
                Void cfr_ignored_0 = (Void)this.process((AstNode)((Object)partitionBy), indent);
            });
            if (node.getHaving().isPresent()) {
                this.append(indent, "HAVING " + SqlFormatter.formatExpression(node.getHaving().get())).append('\n');
            }
            if (!node.isPullQuery() && node.getRefinement().isPresent()) {
                this.append(indent, "EMIT ");
                this.append(indent, node.getRefinement().get().getOutputRefinement().toString()).append('\n');
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().getAsInt()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            List<SelectItem> selectItems = node.getSelectItems();
            if (selectItems.size() > 1) {
                boolean first = true;
                for (SelectItem item : selectItems) {
                    this.builder.append(first ? "" : ",").append("\n  ").append(Formatter.indentString(indent));
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((AstNode)((Object)Iterables.getOnlyElement(selectItems)), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(SqlFormatter.formatExpression(node.getExpression()));
            if (node.getAlias().isPresent()) {
                this.builder.append(' ').append(node.getAlias().get().toString(FormatOptions.of(IdentifierUtil::needsQuotes)));
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer context) {
            node.getSource().ifPresent(source -> this.builder.append(SqlFormatter.escapedName((Name)source)).append("."));
            this.builder.append("*");
            return null;
        }

        @Override
        protected Void visitStructAll(StructAll node, Integer context) {
            this.builder.append(node.getBaseStruct() + "->" + "*");
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(SqlFormatter.escapedName((Name)node.getName()));
            return null;
        }

        @Override
        protected Void visitJoin(Join join, Integer indent) {
            this.process(join.getLeft(), indent);
            join.getRights().forEach(node -> {
                Void cfr_ignored_0 = (Void)this.process((AstNode)((Object)node), indent);
            });
            return null;
        }

        @Override
        protected Void visitJoinedSource(JoinedSource node, Integer indent) {
            String type = node.getType().getFormatted();
            this.builder.append('\n');
            this.append(indent, type).append(" JOIN ");
            this.process(node.getRelation(), indent);
            JoinCriteria criteria = node.getCriteria();
            node.getWithinExpression().map(e -> this.builder.append(e.toString()));
            JoinOn on = (JoinOn)criteria;
            this.builder.append(" ON (").append(SqlFormatter.formatExpression(on.getExpression())).append(")");
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(' ').append(SqlFormatter.escapedName((Name)node.getAlias()));
            return null;
        }

        @Override
        protected Void visitCreateStream(CreateStream node, Integer indent) {
            this.formatCreate(node, "STREAM");
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.formatCreate(node, "TABLE");
            return null;
        }

        @Override
        public Void visitAssertStream(AssertStream node, Integer context) {
            this.formatAssertSource(node.getStatement(), "STREAM");
            return null;
        }

        @Override
        public Void visitAssertTable(AssertTable node, Integer context) {
            this.formatAssertSource(node.getStatement(), "TABLE");
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            this.builder.append("\n");
            node.getQueryId().ifPresent(queryId -> this.append(indent, (String)queryId));
            node.getStatement().ifPresent(stmt -> {
                Void cfr_ignored_0 = (Void)this.process((AstNode)((Object)stmt), indent);
            });
            return null;
        }

        @Override
        protected Void visitShowColumns(ShowColumns node, Integer context) {
            this.builder.append("DESCRIBE ").append(SqlFormatter.escapedName((Name)node.getTable()));
            return null;
        }

        @Override
        protected Void visitShowFunctions(ListFunctions node, Integer context) {
            this.builder.append("SHOW FUNCTIONS");
            return null;
        }

        @Override
        protected Void visitCreateStreamAsSelect(CreateStreamAsSelect node, Integer indent) {
            this.formatCreateAs("STREAM", node, indent);
            return null;
        }

        @Override
        protected Void visitCreateTableAsSelect(CreateTableAsSelect node, Integer indent) {
            this.formatCreateAs("TABLE", node, indent);
            return null;
        }

        @Override
        protected Void visitInsertInto(InsertInto node, Integer indent) {
            this.builder.append("INSERT INTO ");
            this.builder.append(SqlFormatter.escapedName((Name)node.getTarget()));
            this.builder.append(" ");
            String insertProps = node.getProperties().toString();
            if (!insertProps.isEmpty()) {
                this.builder.append(" WITH (").append(insertProps).append(")");
                this.builder.append(" ");
            }
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitDropStream(DropStream node, Integer context) {
            this.visitDrop(node, "STREAM");
            return null;
        }

        @Override
        protected Void visitInsertValues(InsertValues node, Integer context) {
            this.builder.append("INSERT INTO ");
            this.builder.append(SqlFormatter.escapedName((Name)node.getTarget()));
            this.builder.append(" ");
            this.visitColumns(node.getColumns());
            this.builder.append("VALUES ");
            this.visitExpressionList(node.getValues());
            return null;
        }

        private void visitColumns(List<ColumnName> columns) {
            if (!columns.isEmpty()) {
                this.builder.append(columns.stream().map(x$0 -> SqlFormatter.escapedName(x$0)).collect(Collectors.joining(", ", "(", ") ")));
            }
        }

        private void visitExpressionList(List<Expression> expressions) {
            this.builder.append("(");
            this.builder.append(expressions.stream().map(x$0 -> SqlFormatter.formatExpression(x$0)).collect(Collectors.joining(", ")));
            this.builder.append(")");
        }

        @Override
        public Void visitAssertValues(AssertValues node, Integer context) {
            this.builder.append("ASSERT VALUES ");
            this.builder.append(SqlFormatter.escapedName((Name)node.getStatement().getTarget()));
            this.builder.append(" ");
            this.visitColumns(node.getStatement().getColumns());
            this.builder.append("VALUES ");
            this.visitExpressionList(node.getStatement().getValues());
            return null;
        }

        @Override
        public Void visitAssertTombstone(AssertTombstone node, Integer context) {
            this.builder.append("ASSERT NULL VALUES ");
            this.builder.append(SqlFormatter.escapedName((Name)node.getStatement().getTarget()));
            this.builder.append(" ");
            this.visitColumns(node.getStatement().getColumns());
            this.builder.append("KEY ");
            this.visitExpressionList(node.getStatement().getValues());
            return null;
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer context) {
            this.visitDrop(node, "TABLE");
            return null;
        }

        @Override
        protected Void visitPauseQuery(PauseQuery node, Integer context) {
            this.builder.append("PAUSE ");
            this.builder.append(node.getQueryId().map(QueryId::toString).orElse("ALL"));
            return null;
        }

        @Override
        protected Void visitResumeQuery(ResumeQuery node, Integer context) {
            this.builder.append("RESUME ");
            this.builder.append(node.getQueryId().map(QueryId::toString).orElse("ALL"));
            return null;
        }

        @Override
        protected Void visitTerminateQuery(TerminateQuery node, Integer context) {
            this.builder.append("TERMINATE ");
            this.builder.append(node.getQueryId().map(QueryId::toString).orElse("ALL"));
            return null;
        }

        @Override
        protected Void visitListStreams(ListStreams node, Integer context) {
            this.builder.append("SHOW STREAMS");
            if (node.getShowExtended()) {
                this.visitExtended();
            }
            return null;
        }

        @Override
        protected Void visitListTables(ListTables node, Integer context) {
            this.builder.append("SHOW TABLES");
            if (node.getShowExtended()) {
                this.visitExtended();
            }
            return null;
        }

        @Override
        protected Void visitListConnectorPlugins(ListConnectorPlugins node, Integer context) {
            this.builder.append("SHOW CONNECTOR PLUGINS");
            return null;
        }

        @Override
        protected Void visitDescribeStreams(DescribeStreams node, Integer context) {
            this.builder.append("DESCRIBE STREAMS");
            if (node.getShowExtended()) {
                this.visitExtended();
            }
            return null;
        }

        @Override
        protected Void visitDescribeTables(DescribeTables node, Integer context) {
            this.builder.append("DESCRIBE TABLES");
            if (node.getShowExtended()) {
                this.visitExtended();
            }
            return null;
        }

        @Override
        protected Void visitUnsetProperty(UnsetProperty node, Integer context) {
            this.builder.append("UNSET '");
            this.builder.append(node.getPropertyName());
            this.builder.append("'");
            return null;
        }

        @Override
        protected Void visitSetProperty(SetProperty node, Integer context) {
            this.builder.append("SET '");
            this.builder.append(node.getPropertyName());
            this.builder.append("'='");
            this.builder.append(node.getPropertyValue());
            this.builder.append("'");
            return null;
        }

        @Override
        protected Void visitAlterSystemProperty(AlterSystemProperty node, Integer context) {
            this.builder.append("ALTER SYSTEM '");
            this.builder.append(node.getPropertyName());
            this.builder.append("'='");
            this.builder.append(node.getPropertyValue());
            this.builder.append("'");
            return null;
        }

        @Override
        protected Void visitDefineVariable(DefineVariable node, Integer context) {
            this.builder.append("DEFINE ");
            this.builder.append(node.getVariableName());
            this.builder.append("='");
            this.builder.append(node.getVariableValue());
            this.builder.append("'");
            return null;
        }

        @Override
        public Void visitListVariables(ListVariables node, Integer context) {
            this.builder.append("SHOW VARIABLES");
            return null;
        }

        @Override
        protected Void visitUndefineVariable(UndefineVariable node, Integer context) {
            this.builder.append("UNDEFINE ");
            this.builder.append(node.getVariableName());
            return null;
        }

        private void visitExtended() {
            this.builder.append(" EXTENDED");
        }

        @Override
        public Void visitRegisterType(RegisterType node, Integer context) {
            this.builder.append("CREATE TYPE ");
            if (node.getIfNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(FORMAT_OPTIONS.escape(node.getName()));
            this.builder.append(" AS ");
            this.builder.append(SqlFormatter.formatExpression((Expression)node.getType()));
            this.builder.append(";");
            return null;
        }

        private void visitDrop(DropStatement node, String sourceType) {
            this.builder.append("DROP ");
            this.builder.append(sourceType);
            this.builder.append(" ");
            if (node.getIfExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.escapedName((Name)node.getName()));
            if (node.isDeleteTopic()) {
                this.builder.append(" DELETE TOPIC");
            }
        }

        @Override
        protected Void visitPartitionBy(PartitionBy node, Integer indent) {
            String expressions = node.getExpressions().stream().map(x$0 -> SqlFormatter.formatExpression(x$0)).collect(Collectors.joining(", "));
            this.append(indent, "PARTITION BY " + expressions).append('\n');
            return null;
        }

        @Override
        protected Void visitGroupBy(GroupBy node, Integer indent) {
            String expressions = node.getGroupingExpressions().stream().map(x$0 -> SqlFormatter.formatExpression(x$0)).collect(Collectors.joining(", "));
            this.append(indent, "GROUP BY " + expressions).append('\n');
            return null;
        }

        @Override
        public Void visitAlterSource(AlterSource node, Integer indent) {
            this.append(indent, String.format("ALTER %s %s%n", node.getDataSourceType().getKsqlType(), node.getName().text()));
            this.builder.append(node.getAlterOptions().stream().map(x$0 -> SqlFormatter.formatAlterOption(x$0)).collect(Collectors.joining(",\n")));
            this.builder.append(";");
            return null;
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(SqlFormatter.escapedName((Name)((Table)relation).getName())).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)SqlFormatter.INDENT, (int)indent);
        }

        private void formatCreate(CreateSource node, String type) {
            this.builder.append("CREATE ");
            if (node.isOrReplace()) {
                this.builder.append("OR REPLACE ");
            }
            if (node.isSource()) {
                this.builder.append("SOURCE ");
            }
            this.builder.append(type);
            this.builder.append(" ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.escapedName((Name)node.getName()));
            this.formatTableElements(node.getElements());
            this.formatTableProperties(node.getProperties());
            this.builder.append(";");
        }

        private void formatAssertSource(CreateSource node, String type) {
            this.builder.append("ASSERT ");
            this.builder.append(type);
            this.builder.append(" ");
            this.builder.append(SqlFormatter.escapedName((Name)node.getName()));
            this.formatTableElements(node.getElements());
            this.formatTableProperties(node.getProperties());
            this.builder.append(";");
        }

        private void formatTableElements(TableElements tableElements) {
            String elements = tableElements.stream().map(Formatter::formatTableElement).collect(Collectors.joining(", "));
            if (!elements.isEmpty()) {
                this.builder.append(" (").append(elements).append(")");
            }
        }

        private void formatTableProperties(CreateSourceProperties properties) {
            String tableProps = properties.toString();
            if (!tableProps.isEmpty()) {
                this.builder.append(" WITH (").append(tableProps).append(")");
            }
        }

        private void formatCreateAs(String source, CreateAsSelect node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isOrReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append(source);
            this.builder.append(" ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.escapedName((Name)node.getName()));
            String tableProps = node.getProperties().toString();
            if (!tableProps.isEmpty()) {
                this.builder.append(" WITH (").append(tableProps).append(")");
            }
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
        }

        private static String formatTableElement(TableElement e) {
            ColumnConstraints columnConstraints = e.getConstraints();
            String postFix = columnConstraints.isPrimaryKey() ? " PRIMARY KEY" : (columnConstraints.isKey() ? " KEY" : (columnConstraints.isHeaders() ? (columnConstraints.getHeaderKey().isPresent() ? " HEADER('" + e.getConstraints().getHeaderKey().get() + "')" : " HEADERS") : ""));
            return SqlFormatter.escapedName((Name)e.getName()) + " " + ExpressionFormatter.formatExpression((Expression)e.getType(), (FormatOptions)FormatOptions.of(IdentifierUtil::needsQuotes)) + postFix;
        }
    }
}

