/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.ksql.execution.windows.HoppingWindowExpression;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.SessionWindowExpression;
import io.confluent.ksql.execution.windows.TumblingWindowExpression;
import io.confluent.ksql.parser.ExpressionParser;
import io.confluent.ksql.util.KsqlException;
import java.io.IOException;

class WindowExpressionDeserializer<T extends KsqlWindowExpression>
extends JsonDeserializer<T> {
    private static final ObjectMapper mapper = new ObjectMapper();

    WindowExpressionDeserializer() {
    }

    public T deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        String windowType;
        TreeNode root = parser.readValueAsTree();
        if (root instanceof TextNode) {
            return (T)ExpressionParser.parseWindowExpression(((TextNode)root).textValue());
        }
        switch (windowType = ((ObjectNode)root).remove("windowType").textValue()) {
            case "TUMBLING": {
                return (T)((KsqlWindowExpression)mapper.convertValue((Object)root, TumblingWindowExpression.class));
            }
            case "HOPPING": {
                return (T)((KsqlWindowExpression)mapper.convertValue((Object)root, HoppingWindowExpression.class));
            }
            case "SESSION": {
                return (T)((KsqlWindowExpression)mapper.convertValue((Object)root, SessionWindowExpression.class));
            }
        }
        throw new KsqlException("Unknown window type: " + windowType);
    }
}

