/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class ColumnConstraints {
    public static final ColumnConstraints NO_COLUMN_CONSTRAINTS = new Builder().build();
    private final boolean primaryKey;
    private final boolean key;
    private final boolean headers;
    private final Optional<String> headerKey;

    private ColumnConstraints(boolean primaryKey, boolean key, boolean headers, Optional<String> headerKey) {
        this.primaryKey = primaryKey;
        this.key = key;
        this.headers = headers;
        this.headerKey = headerKey;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isHeaders() {
        return this.headers;
    }

    public Optional<String> getHeaderKey() {
        return this.headerKey;
    }

    public int hashCode() {
        return Objects.hash(this.primaryKey, this.key, this.headerKey, this.headerKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnConstraints o = (ColumnConstraints)obj;
        return Objects.equals(this.primaryKey, o.primaryKey) && Objects.equals(this.key, o.key) && Objects.equals(this.headers, o.headers) && Objects.equals(this.headerKey, o.headerKey);
    }

    public String toString() {
        return "ColumnConstraints{primaryKey=" + this.primaryKey + ", key=" + this.key + ", headers=" + this.headers + ", headerKey=" + this.headerKey + '}';
    }

    public static class Builder {
        private boolean primaryKey = false;
        private boolean key = false;
        private boolean headers = false;
        private Optional<String> headerKey = Optional.empty();

        public Builder primaryKey() {
            Preconditions.checkArgument((!this.key && !this.headers ? 1 : 0) != 0, (Object)"Primary key cannot be used if a key or headers constraint are already defined");
            this.primaryKey = true;
            return this;
        }

        public Builder key() {
            Preconditions.checkArgument((!this.primaryKey && !this.headers ? 1 : 0) != 0, (Object)"Key cannot be used if a primary key or headers constraint are already defined");
            this.key = true;
            return this;
        }

        public Builder headers() {
            Preconditions.checkArgument((!this.primaryKey && !this.key ? 1 : 0) != 0, (Object)"Headers cannot be used if a key is already defined");
            this.headers = true;
            return this;
        }

        public Builder header(String headerKey) {
            Preconditions.checkArgument((!this.primaryKey && !this.key ? 1 : 0) != 0, (Object)"Headers columns cannot be used if a key is already defined");
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)headerKey), (Object)"Header column must have a non-empty header key name defined");
            this.headers = true;
            this.headerKey = Optional.of(headerKey);
            return this;
        }

        public ColumnConstraints build() {
            return new ColumnConstraints(this.primaryKey, this.key, this.headers, this.headerKey);
        }
    }
}

