/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.StatementWithExtendedClause;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class ShowColumns
extends StatementWithExtendedClause {
    private final SourceName table;
    private final boolean isExtended;

    public ShowColumns(SourceName table, boolean isExtended) {
        this(Optional.empty(), table, isExtended);
    }

    public ShowColumns(Optional<NodeLocation> location, SourceName table, boolean isExtended) {
        super(location, isExtended);
        this.table = Objects.requireNonNull(table, "table");
        this.isExtended = isExtended;
    }

    public SourceName getTable() {
        return this.table;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowColumns(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ShowColumns that = (ShowColumns)((Object)o);
        return this.isExtended == that.isExtended && Objects.equals(this.table, that.table);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.isExtended);
    }

    @Override
    public String toString() {
        return "ShowColumns{table=" + this.table + ", isExtended=" + this.isExtended + '}';
    }
}

