/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.SelectItem;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class StructAll
extends SelectItem {
    private final Expression baseStruct;

    public StructAll(Expression identifier) {
        this(Optional.empty(), identifier);
    }

    public StructAll(Optional<NodeLocation> location, Expression baseStruct) {
        super(location);
        this.baseStruct = Objects.requireNonNull(baseStruct, "identifier");
    }

    public Expression getBaseStruct() {
        return this.baseStruct;
    }

    public int hashCode() {
        return this.baseStruct.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StructAll that = (StructAll)((Object)o);
        return Objects.equals(this.baseStruct, that.baseStruct);
    }

    public String toString() {
        return "StructAll{, baseStruct=" + this.baseStruct + '}';
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitStructAll(this, context);
    }
}

