/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.kstream.JoinWindows;

@Immutable
public class WithinExpression
extends AstNode {
    private final long before;
    private final long after;
    private final TimeUnit beforeTimeUnit;
    private final TimeUnit afterTimeUnit;
    private final JoinWindows joinWindows;
    private final Optional<WindowTimeClause> gracePeriod;

    public WithinExpression(long size, TimeUnit timeUnit) {
        this(Optional.empty(), size, size, timeUnit, timeUnit, Optional.empty());
    }

    public WithinExpression(long size, TimeUnit timeUnit, WindowTimeClause gracePeriod) {
        this(Optional.empty(), size, size, timeUnit, timeUnit, Optional.of(gracePeriod));
    }

    public WithinExpression(long before, long after, TimeUnit beforeTimeUnit, TimeUnit afterTimeUnit, WindowTimeClause gracePeriod) {
        this(Optional.empty(), before, after, beforeTimeUnit, afterTimeUnit, Optional.of(gracePeriod));
    }

    public WithinExpression(long before, long after, TimeUnit beforeTimeUnit, TimeUnit afterTimeUnit) {
        this(Optional.empty(), before, after, beforeTimeUnit, afterTimeUnit, Optional.empty());
    }

    public WithinExpression(Optional<NodeLocation> location, long before, long after, TimeUnit beforeTimeUnit, TimeUnit afterTimeUnit, Optional<WindowTimeClause> gracePeriod) {
        super(location);
        this.before = before;
        this.after = after;
        this.beforeTimeUnit = Objects.requireNonNull(beforeTimeUnit, "beforeTimeUnit");
        this.afterTimeUnit = Objects.requireNonNull(afterTimeUnit, "afterTimeUnit");
        this.gracePeriod = Objects.requireNonNull(gracePeriod, "gracePeriod");
        this.joinWindows = this.createJoinWindows();
    }

    public JoinWindows joinWindow() {
        return this.joinWindows;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWithinExpression(this, context);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" WITHIN ");
        if (this.before == this.after) {
            builder.append(this.before).append(' ').append((Object)this.beforeTimeUnit);
        } else {
            builder.append('(').append(this.before).append(' ').append((Object)this.beforeTimeUnit).append(", ").append(this.after).append(' ').append((Object)this.afterTimeUnit).append(")");
        }
        this.gracePeriod.ifPresent(windowTimeClause -> builder.append(" GRACE PERIOD ").append(windowTimeClause.getValue()).append(' ').append((Object)windowTimeClause.getTimeUnit()));
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.before, this.after, this.beforeTimeUnit, this.afterTimeUnit, this.gracePeriod});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WithinExpression withinExpression = (WithinExpression)((Object)o);
        return this.before == withinExpression.before && this.after == withinExpression.after && Objects.equals((Object)this.beforeTimeUnit, (Object)withinExpression.beforeTimeUnit) && Objects.equals((Object)this.afterTimeUnit, (Object)withinExpression.afterTimeUnit) && Objects.equals(this.gracePeriod, withinExpression.gracePeriod);
    }

    private JoinWindows createJoinWindows() {
        JoinWindows joinWindow = JoinWindows.of((Duration)Duration.ofMillis(this.beforeTimeUnit.toMillis(this.before))).after(Duration.ofMillis(this.afterTimeUnit.toMillis(this.after)));
        return this.gracePeriod.isPresent() ? joinWindow.grace(this.gracePeriod.get().toDuration()) : joinWindow;
    }

    public long getBefore() {
        return this.before;
    }

    public long getAfter() {
        return this.after;
    }

    public Optional<WindowTimeClause> getGrace() {
        return this.gracePeriod;
    }

    public TimeUnit getBeforeTimeUnit() {
        return this.beforeTimeUnit;
    }

    public TimeUnit getAfterTimeUnit() {
        return this.afterTimeUnit;
    }
}

