/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.aws;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.crypto.tink.Aead;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.utils.BinaryUtils;

public final class AwsKmsAead
implements Aead {
    private final KmsClient kmsClient;
    private final String keyArn;

    public AwsKmsAead(KmsClient kmsClient, String keyArn) {
        this.kmsClient = kmsClient;
        this.keyArn = keyArn;
    }

    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        try {
            EncryptRequest.Builder req = EncryptRequest.builder().keyId(this.keyArn).plaintext(SdkBytes.fromByteArray((byte[])plaintext));
            if (associatedData != null && associatedData.length != 0) {
                ImmutableMap context = ImmutableMap.of((Object)"associatedData", (Object)BinaryUtils.toHex((byte[])associatedData));
                req = req.encryptionContext((Map)context);
            }
            return this.kmsClient.encrypt((EncryptRequest)req.build()).ciphertextBlob().asByteArray();
        }
        catch (AwsServiceException e) {
            throw new GeneralSecurityException("encryption failed", e);
        }
    }

    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        try {
            DecryptRequest.Builder req = DecryptRequest.builder().keyId(this.keyArn).ciphertextBlob(SdkBytes.fromByteArray((byte[])ciphertext));
            if (associatedData != null && associatedData.length != 0) {
                ImmutableMap context = ImmutableMap.of((Object)"associatedData", (Object)BinaryUtils.toHex((byte[])associatedData));
                req = req.encryptionContext((Map)context);
            }
            DecryptResponse result = this.kmsClient.decrypt((DecryptRequest)req.build());
            if (AwsKmsAead.isKeyArnFormat(this.keyArn) && !result.keyId().equals(this.keyArn)) {
                throw new GeneralSecurityException("decryption failed: wrong key id");
            }
            return result.plaintext().asByteArray();
        }
        catch (AwsServiceException e) {
            throw new GeneralSecurityException("decryption failed", e);
        }
    }

    private static boolean isKeyArnFormat(String keyArn) {
        List tokens = Splitter.on((char)':').splitToList((CharSequence)keyArn);
        return tokens.size() == 6 && ((String)tokens.get(5)).startsWith("key/");
    }
}

