/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.utils.Utils;

@InterfaceStability.Evolving
public class MirrorTopicDescription {
    private final String linkName;
    private final Uuid linkId;
    private final String sourceTopic;
    private final int numPartitions;
    private final State state;
    private final long stateTimeMs;
    private final List<Long> stoppedLogEndOffsets;
    private final Uuid sourceTopicId;
    private final MirrorTopicError mirrorTopicError;
    private final List<ClusterLinkTaskError> mirrorStateTransitionErrors;

    @Deprecated
    public MirrorTopicDescription(String linkName, UUID linkId, String sourceTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets) {
        this(linkName, Utils.toKafkaUuid(linkId), sourceTopic, numPartitions, state, stateTimeMs, stoppedLogEndOffsets);
    }

    @Deprecated
    public MirrorTopicDescription(String linkName, Uuid linkId, String sourceTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets) {
        this(linkName, linkId, sourceTopic, numPartitions, state, stateTimeMs, stoppedLogEndOffsets, Uuid.ZERO_UUID);
    }

    @Deprecated
    public MirrorTopicDescription(String linkName, Uuid linkId, String sourceTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets, Uuid sourceTopicId) {
        this(linkName, linkId, sourceTopic, numPartitions, state, stateTimeMs, stoppedLogEndOffsets, sourceTopicId, MirrorTopicError.NOT_SET);
    }

    public MirrorTopicDescription(String linkName, Uuid linkId, String sourceTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets, Uuid sourceTopicId, MirrorTopicError mirrorTopicError) {
        this(linkName, linkId, sourceTopic, numPartitions, state, stateTimeMs, stoppedLogEndOffsets, sourceTopicId, MirrorTopicError.errorOrDefault(mirrorTopicError, state == State.FAILED), Collections.emptyList());
    }

    public MirrorTopicDescription(String linkName, Uuid linkId, String sourceTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets, Uuid sourceTopicId, MirrorTopicError mirrorTopicError, List<ClusterLinkTaskError> mirrorStateTransitionErrors) {
        this.linkName = Objects.requireNonNull(linkName);
        this.linkId = Objects.requireNonNull(linkId);
        this.sourceTopic = Objects.requireNonNull(sourceTopic);
        this.numPartitions = numPartitions;
        this.state = Objects.requireNonNull(state);
        this.stateTimeMs = stateTimeMs;
        this.stoppedLogEndOffsets = Objects.requireNonNull(stoppedLogEndOffsets);
        this.sourceTopicId = sourceTopicId;
        this.mirrorTopicError = MirrorTopicError.errorOrDefault(mirrorTopicError, state == State.FAILED);
        this.mirrorStateTransitionErrors = mirrorStateTransitionErrors;
    }

    public String linkName() {
        return this.linkName;
    }

    @Deprecated
    public UUID linkId() {
        return Utils.toJavaUuid(this.linkId);
    }

    public Uuid clusterLinkId() {
        return this.linkId;
    }

    @Deprecated
    public String mirrorTopic() {
        return this.sourceTopic;
    }

    public String sourceTopic() {
        return this.sourceTopic;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public State state() {
        return this.state;
    }

    public long stateTimeMs() {
        return this.stateTimeMs;
    }

    public List<Long> stoppedLogEndOffsets() {
        return this.stoppedLogEndOffsets;
    }

    public Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    public MirrorTopicError mirrorTopicError() {
        return this.mirrorTopicError;
    }

    public List<ClusterLinkTaskError> mirrorStateTransitionErrors() {
        return this.mirrorStateTransitionErrors;
    }

    public String toString() {
        return "(linkName=" + this.linkName + ", linkId=" + this.linkId + ", sourceTopic=" + this.sourceTopic + ", numPartitions=" + this.numPartitions + ", state=" + (Object)((Object)this.state) + ", stateTimeMs=" + this.stateTimeMs + ", stoppedLogEndOffsets=" + this.stoppedLogEndOffsets + ", sourceTopicId=" + this.sourceTopicId + ", mirrorStateTransitionErrors=" + this.mirrorStateTransitionErrors + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorTopicDescription that = (MirrorTopicDescription)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.sourceTopic, that.sourceTopic) && Objects.equals(this.numPartitions, that.numPartitions) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.stateTimeMs, that.stateTimeMs) && Objects.equals(this.stoppedLogEndOffsets, that.stoppedLogEndOffsets) && Objects.equals(this.sourceTopicId, that.sourceTopicId) && Objects.equals((Object)this.mirrorTopicError, (Object)that.mirrorTopicError) && Objects.equals(this.mirrorStateTransitionErrors, that.mirrorStateTransitionErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linkName, this.linkId, this.sourceTopic, this.numPartitions, this.state, this.stateTimeMs, this.sourceTopicId, this.mirrorTopicError, this.mirrorStateTransitionErrors});
    }

    public static enum State {
        UNKNOWN,
        ACTIVE,
        PENDING_STOPPED,
        STOPPED,
        FAILED,
        PAUSED,
        SOURCE_UNAVAILABLE,
        LINK_FAILED,
        LINK_PAUSED,
        PENDING_MIRROR,
        PENDING_SYNCHRONIZE,
        PENDING_REPAIR;

    }
}

