/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Type;

public class ConsumerProtocol {
    public static final String TOPICS_KEY_NAME = "topics";
    public static final String PROTOCOL_TYPE = "consumer";
    public static final String VERSION_KEY_NAME = "version";
    public static final Schema CONSUMER_PROTOCOL_HEADER_SCHEMA = new Schema(new Field("version", Type.INT16));

    public static short deserializeVersion(ByteBuffer buffer) {
        try {
            return buffer.getShort();
        }
        catch (BufferUnderflowException e) {
            throw new SchemaException("Buffer underflow while parsing consumer protocol's header", e);
        }
    }

    public static ByteBuffer serializeSubscription(ConsumerPartitionAssignor.Subscription subscription) {
        return ConsumerProtocol.serializeSubscription(subscription, (short)3);
    }

    public static ByteBuffer serializeSubscription(ConsumerPartitionAssignor.Subscription subscription, short version) {
        version = ConsumerProtocol.checkSubscriptionVersion(version);
        ConsumerProtocolSubscription data = new ConsumerProtocolSubscription();
        ArrayList<String> topics = new ArrayList<String>(subscription.topics());
        Collections.sort(topics);
        data.setTopics(topics);
        data.setUserData(subscription.userData() != null ? subscription.userData().duplicate() : null);
        ArrayList<TopicPartition> ownedPartitions = new ArrayList<TopicPartition>(subscription.ownedPartitions());
        ownedPartitions.sort(Comparator.comparing(TopicPartition::topic).thenComparing(TopicPartition::partition));
        ConsumerProtocolSubscription.TopicPartition partition = null;
        for (TopicPartition tp : ownedPartitions) {
            if (partition == null || !partition.topic().equals(tp.topic())) {
                partition = new ConsumerProtocolSubscription.TopicPartition().setTopic(tp.topic());
                data.ownedPartitions().add(partition);
            }
            partition.partitions().add(tp.partition());
        }
        subscription.rackId().ifPresent(data::setRackId);
        data.setGenerationId(subscription.generationId().orElse(-1));
        return MessageUtil.toVersionPrefixedByteBuffer(version, data);
    }

    public static ConsumerPartitionAssignor.Subscription deserializeSubscription(ByteBuffer buffer, short version) {
        version = ConsumerProtocol.checkSubscriptionVersion(version);
        try {
            ConsumerProtocolSubscription data = new ConsumerProtocolSubscription(new ByteBufferAccessor(buffer), version);
            ArrayList<TopicPartition> ownedPartitions = new ArrayList<TopicPartition>();
            for (ConsumerProtocolSubscription.TopicPartition tp : data.ownedPartitions()) {
                for (Integer partition : tp.partitions()) {
                    ownedPartitions.add(new TopicPartition(tp.topic(), partition));
                }
            }
            return new ConsumerPartitionAssignor.Subscription(data.topics(), data.userData() != null ? data.userData().duplicate() : null, ownedPartitions, data.generationId(), data.rackId() == null || data.rackId().isEmpty() ? Optional.empty() : Optional.of(data.rackId()));
        }
        catch (BufferUnderflowException e) {
            throw new SchemaException("Buffer underflow while parsing consumer protocol's subscription", e);
        }
    }

    public static ConsumerPartitionAssignor.Subscription deserializeSubscription(ByteBuffer buffer) {
        return ConsumerProtocol.deserializeSubscription(buffer, ConsumerProtocol.deserializeVersion(buffer));
    }

    public static ByteBuffer serializeAssignment(ConsumerPartitionAssignor.Assignment assignment) {
        return ConsumerProtocol.serializeAssignment(assignment, (short)3);
    }

    public static ByteBuffer serializeAssignment(ConsumerPartitionAssignor.Assignment assignment, short version) {
        version = ConsumerProtocol.checkAssignmentVersion(version);
        ConsumerProtocolAssignment data = new ConsumerProtocolAssignment();
        data.setUserData(assignment.userData() != null ? assignment.userData().duplicate() : null);
        assignment.partitions().forEach(tp -> {
            ConsumerProtocolAssignment.TopicPartition partition = data.assignedPartitions().find(tp.topic());
            if (partition == null) {
                partition = new ConsumerProtocolAssignment.TopicPartition().setTopic(tp.topic());
                data.assignedPartitions().add(partition);
            }
            partition.partitions().add(tp.partition());
        });
        return MessageUtil.toVersionPrefixedByteBuffer(version, data);
    }

    public static ConsumerPartitionAssignor.Assignment deserializeAssignment(ByteBuffer buffer, short version) {
        version = ConsumerProtocol.checkAssignmentVersion(version);
        try {
            ConsumerProtocolAssignment data = new ConsumerProtocolAssignment(new ByteBufferAccessor(buffer), version);
            ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
            for (ConsumerProtocolAssignment.TopicPartition tp : data.assignedPartitions()) {
                for (Integer partition : tp.partitions()) {
                    assignedPartitions.add(new TopicPartition(tp.topic(), partition));
                }
            }
            return new ConsumerPartitionAssignor.Assignment(assignedPartitions, data.userData() != null ? data.userData().duplicate() : null);
        }
        catch (BufferUnderflowException e) {
            throw new SchemaException("Buffer underflow while parsing consumer protocol's assignment", e);
        }
    }

    public static ConsumerPartitionAssignor.Assignment deserializeAssignment(ByteBuffer buffer) {
        return ConsumerProtocol.deserializeAssignment(buffer, ConsumerProtocol.deserializeVersion(buffer));
    }

    private static short checkSubscriptionVersion(short version) {
        if (version < 0) {
            throw new SchemaException("Unsupported subscription version: " + version);
        }
        if (version > 3) {
            return 3;
        }
        return version;
    }

    private static short checkAssignmentVersion(short version) {
        if (version < 0) {
            throw new SchemaException("Unsupported assignment version: " + version);
        }
        if (version > 3) {
            return 3;
        }
        return version;
    }
}

